% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simul.evol.enz.multiple.R
\name{simul.evol.enz.multiple}
\alias{simul.evol.enz.multiple}
\title{Multiple simulations of enzyme evolution}
\usage{
simul.evol.enz.multiple(E_ini_fun, kin_fun, Keq_fun, nsim, 
N_fun, correl_fun, beta_fun=NULL, X_fun=1, pasobs=250, npt=500, 
same.E0=TRUE, is.random.E0=FALSE, same.kin0=TRUE, is.random.kin0=FALSE,
Etot_fun=100, kin_max=1000, max_mut_size_E=1, max_mut_size_A=1,
pmutA=0, typ_E=1, typ_A=1, use.old.mut=FALSE)
}
\arguments{
\item{E_ini_fun}{Numeric vector of the initial concentrations}

\item{kin_fun}{Numeric vector of the initial kinetic parameters}

\item{Keq_fun}{Numeric vector of equilibrium constants}

\item{nsim}{Numeric. Number of simulations}

\item{N_fun}{Numeric. Population size}

\item{correl_fun}{Character string indicating the abbreviation of the constraint applied on the system}

\item{beta_fun}{Matrix of co-regulation coefficients}

\item{X_fun}{Numeric. Numerator of function \code{\link{flux}}. Default is 1}

\item{pasobs}{Numeric. Number of time steps between two successive observations of the system. Default is \code{250}}

\item{npt}{Numeric. Number of observations. Default is \code{500}}

\item{same.E0, same.kin0}{Logical. Uses same \code{E_ini_fun} / \code{kin_fun} for all simulations ? Default is \code{TRUE}.}

\item{is.random.E0, is.random.kin0}{Logical. Is \code{E_ini_fun} / \code{kin_fun} chosen randomly ? Default is \code{FALSE}.}

\item{Etot_fun}{Numeric. Total concentration if \code{is.random.E0} is \code{TRUE}. Default is \code{100}.}

\item{kin_max}{Numeric. Maximal value for random \code{kin_fun}. Default is \code{1000}.}

\item{max_mut_size_E}{Numeric. Maximum absolute size of mutation for enzyme concentrations. Default is 1}

\item{max_mut_size_A}{Numeric. Maximum absolute size of mutation for kinetic parameters. Default is 1}

\item{pmutA}{Numeric. Mutation probability of kinetic parameters.
Higher \code{pmutA}, higher the mutation probability of kinetic parameters compared to enzyme concentrations.
Default is 0, i.e. no mutation of kinetic parameters}

\item{typ_E}{Numeric for mutation method. Authorized values: 1 or 2. Default is 1.}

\item{typ_A}{Numeric for mutation method. Default is 1. \emph{See details in \code{\link{mut.kin}}.}}

\item{use.old.mut}{Logical. If \code{FALSE} (default), use \code{\link{mut.E.direct}} mutation method, else use \code{\link{mut.E.old}} mutation method if \code{TRUE}}
}
\value{
Invisible list of 6 elements:
\itemize{
   \item \code{$tabR}: dataframe of \code{nsim x npt} rows and \code{3*n+4} columns.
   Each row corresponds to state at each observation step (i.e. after \code{pasobs} mutations),
   and columns are respectively concentrations (\code{1:n}), kinetic parameters (\code{n+1:2n}), total concentration (\code{2n+1}), total kinetic (\code{2n+2}), flux/fitness (\code{2n+3}), activities (\code{2n+4:3n+3}), and simulation number (\code{$sim} or \code{3n+4});
   \item \code{$tabP_e}: numeric matrix of \code{npt} rows and \code{n+1} columns, corresponding to relative concentrations at equilibrium (column 1 to \code{n}) for each observation step (in rows), plus column \code{$sim};
   \item \code{$tabP_r}: same as \code{$tabP_e}, but for response coefficients
   \item \code{$list_init}: list of 3 elements, containing initial values of concentrations in \code{$E0}, kinetic parameters in \code{$kin0} and activities in \code{$A0} for each simulation. Each element is a numeric matrix of \code{nsim} rows (one by simulation) and \code{n} columns (one by enzyme);
   \item \code{$list_final}: list of 3 elements, containing final values of concentrations in \code{$E_f}, kinetic parameters in \code{$kin_f} and activities in \code{$A_f} for each simulation. Each element is a numeric matrix of \code{nsim} rows and \code{n} columns;
   \item \code{$param}: list of input parameters.
}

Note that \code{n} is the number of enzymes, which is the length of \code{E_ini_fun}.
}
\description{
This function gives multiple simulations of evolution of enzyme concentrations under constraints
}
\details{
Details about how does simulations work are in function \code{\link{simul.evol.enz.one}} documentation. 

\emph{Apply would also work, but only for multiple values of \code{E_ini_fun}.
\code{simul.evol.enz.multiple} gives all results in a same table, and has the possibility to change kinetic parameters between simulation.}

\bold{Initial parameters}

You can choose if initial concentrations and initial kinetic parameters are identical between all simulations by setting \code{same.E0} and \code{same.kin0}.

You can choose randomly initial concentrations and initial kinetic parameters by setting \code{is.random.E0} and \code{is.random.kin0}.

Four cases are possible. Examples are given for initial concentrations, but are the same for kinetic parameters, where \code{same.E0}, \code{is.random.E0} and \code{E_ini_fun} are respectively \code{same.kin0}, \code{is.random.kin0} and \code{kin_fun}.
\itemize{
   \item \code{same.E0} is \code{TRUE} and \code{is.random.E0} is \code{FALSE} is default parameters. In this case, input \code{E_ini_fun} of length \code{n} is used for all simulations.
   \item If \code{same.E0} and \code{is.random.E0} are \code{TRUE}, \code{E_ini_fun} is chosen randomly and used for all \code{nsim} simulations.
   \item If \code{same.E0} is \code{FALSE} and \code{is.random.E0} \code{TRUE}, each simulation has different random initial concentrations.
   \item If \code{same.E0} and \code{is.random.E0} are \code{FALSE}, a matrix of \code{n} columns and \code{nsim} rows is needed for \code{E_ini_fun}, each row corresponding to one simulation.
}

\code{$list_init} is the return for initial concentrations, kinetic parameters and activities.


\bold{Other details}

Note that \code{n} is the number of enzyme and is determined by length of \code{Keq_fun}.
}
\examples{

\donttest{
# case for 3 enzymes
n <- 3
E0 <- c(30,30,30)
kin <- c(1,10,30)
Keq <- c(1,1,1)
nsim <- 2 # 2 simulations
N <- 1000
beta <- diag(1,n)
beta[upper.tri(beta)] <- c(0.32,0.32*(-0.43),-0.43)
#beta_12 = 0.32, beta_13 = beta_12 x beta_23, beta_23 = -0.43
t_beta <- t(beta) #because R fills matrix column by column
beta[lower.tri(beta)] <- 1/t_beta[lower.tri(t_beta)] #beta_ji = 1/beta_ij
if (n==3) {beta[lower.tri(beta)] <- 1/beta[upper.tri(beta)]} #only available if n=3
correl <- "RegNeg"

evol_sim <- simul.evol.enz.multiple(E0,kin,Keq,nsim,N,correl,beta)
evol_sim$tabR[,1:n] #concentrations
evol_sim$tabR[,(n+1):(2*n)] #kinetic parameters
evol_sim$tabR[,(2*n+1)] #total concentration
evol_sim$tabR[,(2*n+2)] #total kinetic
evol_sim$tabR[,(2*n+3)] #flux
evol_sim$tabR[,(2*n+4):(3*n+3)] #activities
evol_sim$tabR$sim #simulation number
evol_sim$tabR[evol_sim$tabR$sim==2,] #results for 2nd simulation
}

}
\seealso{
See function \code{\link{simul.evol.enz.one}} to see how works a simulation.
}
