% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_group.R
\name{class_group}
\alias{class_group}
\title{Classify enzymes in regulation groups}
\usage{
class_group(beta_fun)
}
\arguments{
\item{beta_fun}{Matrix of co-regulation coefficients}
}
\value{
Return a list classically named \code{L_Phi} of length \code{p} (the number of regulation groups). Each element \code{q} of \code{L_Phi} (the regulation group \eqn{\Phi_q}) contains the numbers of co-regulated enzymes.
}
\description{
Classify the enzymes in their corresponding regulation group from the co-regulation matrix
}
\details{
Enzymes are classified in regulation groups depending on the co-regulation matrix.
If the co-regulation coefficient is equal to zero between enzymes, the enzymes are in different regulation group, else there are in the same group.

Enzyme 1 is in the regulation group 1.
Other enzymes are classified in ascending order.
}
\examples{

#Only one group
beta <- matrix(c(1,10,5,0.1,1,0.5,0.2,2,1),nrow=3)
L_Phi <- class_group(beta)

#total number of regulation groups
p <- length(L_Phi) #gives 1


#Two groups
n <- 3
beta <- diag(1,n) 
beta[1,2] <- -0.32 
beta[2,1] <- 1/beta[1,2]

L_Phi <- class_group(beta)
p <- length(L_Phi) #gives 2


#with data
data(data_sim_RegNeg_1grpNeg1grpPos)
class_group(data_sim_RegNeg_1grpNeg1grpPos$param$beta)

}
\seealso{
Function \code{\link{search_group}} to find the group of an enzyme.
}
