% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RNV.ranking.order.factor.R
\name{RNV.ranking.order.factor}
\alias{RNV.ranking.order.factor}
\title{Name and value of RNV-ranking-order factor}
\usage{
RNV.ranking.order.factor(A_fun,correl_fun,E_ini_fun,B_fun=NULL)
}
\arguments{
\item{A_fun}{Numeric vector of activities}

\item{correl_fun}{Character string indicating the abbreviation of the constraint applied on the system}

\item{E_ini_fun}{Numeric vector of initial concentrations.}

\item{B_fun}{Numeric vector of global co-regulation coefficients}
}
\value{
Invisible list of 2 elements:
\itemize{
   \item \code{$value}: numeric vector (length \code{n}) of the values of the RNV-ranking-order factor for each enzymes
   \item \code{$name}: character sting indicating the name of the RNV-ranking-order variable
}
}
\description{
Gives the name and values of the RNV-ranking-order factor
}
\details{
\bold{Factors governing ranking order of RNV}

RNV-ranking-order factor depends on constraint. It would be:
\itemize{
   \item in case of independence (\code{correl_fun="SC"}): activities \code{A} power 1/3;
   \item in case of competition only (\code{correl_fun="Comp"}): activities \code{A} power 1/4;
   \item in case of regulation only (\code{correl_fun="RegPos"} or \code{"RegNeg"}): absolute value of inverse of global co-regulation coefficients \code{|1/B|};
   \item in case of competition and regulation (\code{correl_fun="CRPos"} or \code{"CRNeg"}): absolute value of inverse of global co-regulation coefficients minus initial relative concentrations \code{|1/B - e0|}.
}
}
\examples{
A <- c(1,20,30)
E0 <- c(30,30,30)

#Independence
rank_var <- RNV.ranking.order.factor(A,"SC",E0)
all.equal(A^(1/3),rank_var$value) #TRUE

#Positive regulation
B <- 1/c(0.2,0.5,0.3)
rank_var <- RNV.ranking.order.factor(A,"RegPos",E0,B)
all.equal(1/B,rank_var$value) #TRUE


}
