% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate_simulations.R
\name{aggregate_simulations}
\alias{aggregate_simulations}
\title{Collapse separate simulation files into a single result}
\usage{
aggregate_simulations(
  files = NULL,
  file_name = "SimDesign_aggregate.rds",
  dirs = NULL,
  results_dirname = "SimDesign_aggregate_results"
)
}
\arguments{
\item{files}{a \code{character} vector containing the names of the simulation's final \code{.rds} files}

\item{file_name}{name of .rds file to save aggregate simulation file to. Default is
\code{'SimDesign_aggregate.rds'}}

\item{dirs}{a \code{character} vector containing the names of the \code{save_results} directories to be
aggregated. A new folder will be created and placed in the \code{results_dirname} output folder}

\item{results_dirname}{the new directory to place the aggregated results files}
}
\value{
if \code{files} is used the function returns a \code{data.frame} with the (weighted) average
  of the simulation results. Otherwise, if \code{dirs} is used, the function returns NULL
}
\description{
This function aggregates the results from SimDesign's \code{\link{runSimulation}} into a single
objects suitable for post-analyses, or combines all the saved results directories and combines
them into one. This is useful when results are run piecewise on one node (e.g., 500 replications
in one batch, 500 again at a later date) or run independently across different
nodes/computers that are not on the same network.
}
\examples{
\dontrun{

setwd('my_working_directory')

## run simulations to save the .rds files (or move them to the working directory)
# runSimulation(..., filename='file1')
# runSimulation(..., filename='file2')

# saves to the hard-drive and stores in workspace
final <- aggregate_simulations(files = c('file1.rds', 'file2.rds'))
final

# aggregate saved results for .rds files and results directories
# runSimulation(..., save_results = TRUE, save_details = list(save_results_dirname = 'dir1'))
# runSimulation(..., save_results = TRUE, save_details = list(save_results_dirname = 'dir2'))

# place new saved results in 'SimDesign_results/' by default
aggregate_simulations(files = c('file1.rds', 'file2.rds'),
                      dirs = c('dir1', 'dir2'))


}
}
\references{
Chalmers, R. P., & Adkins, M. C.  (2020). Writing Effective and Reliable Monte Carlo Simulations
with the SimDesign Package. \code{The Quantitative Methods for Psychology, 16}(4), 248-280.
\doi{10.20982/tqmp.16.4.p248}

Sigal, M. J., & Chalmers, R. P. (2016). Play it again: Teaching statistics with Monte
Carlo simulation. \code{Journal of Statistics Education, 24}(3), 136-156.
\doi{10.1080/10691898.2016.1246953}
}
\seealso{
\code{\link{runSimulation}}
}
\author{
Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
