% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_functions.R
\name{RD}
\alias{RD}
\title{Compute the relative difference}
\usage{
RD(est, pop, as.vector = TRUE)
}
\arguments{
\item{est}{a \code{numeric} vector or matrix containing the parameter estimates}

\item{pop}{a \code{numeric} vector or matrix containing the true parameter values. Must be
of the same dimensions as \code{est}}

\item{as.vector}{logical; always wrap the result in a \code{\link{as.vector}} function
before returning?}
}
\value{
returns a \code{vector} or \code{matrix} depending on the inputs and whether
  \code{as.vector} was used
}
\description{
Computes the relative difference statistic of the form \code{(est - pop)/ pop}, which
is equivalent to the form \code{est/pop - 1}. If matricies are supplied then
an equivalent matrix variant will be used of the form
\code{(est - pop) * solve(pop)}. Values closer to 0 indicate better
relative parameter recovery.
}
\examples{

# vector
pop <- seq(1, 100, length.out=9)
est1 <- pop + rnorm(9, 0, .2)
(rds <- RD(est1, pop))
summary(rds)

# matrix
pop <- matrix(c(1:8, 10), 3, 3)
est2 <- pop + rnorm(9, 0, .2)
RD(est2, pop, as.vector = FALSE)
(rds <- RD(est2, pop))
summary(rds)


}

