% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{compute_partial_r2}
\alias{compute_partial_r2}
\title{Compute Partial R-squared}
\usage{
compute_partial_r2(y, X_interest, X_control = NULL, weights = NULL)
}
\arguments{
\item{y}{Numeric vector of the outcome variable.}

\item{X_interest}{Matrix of predictors of interest.}

\item{X_control}{Matrix of control predictors. Can be NULL for simple
R-squared.}

\item{weights}{Optional observation weights.}
}
\value{
Numeric scalar representing partial R-squared (0 to 1).
}
\description{
Calculates the partial R-squared for a specific predictor or block of
predictors, measuring their unique contribution to explaining variance
in the outcome after controlling for other predictors.
}
\details{
Partial R-squared is computed as:
\deqn{R^2_{partial} = (SSE_{reduced} - SSE_{full}) / SSE_{reduced}}

where SSE is the sum of squared errors. This measures the proportional
reduction in unexplained variance achieved by adding the predictors of
interest to a model that already contains the control predictors.
}
\references{
Cohen, J., Cohen, P., West, S. G., & Aiken, L. S. (2003). Applied Multiple
Regression/Correlation Analysis for the Behavioral Sciences (3rd ed.).
Lawrence Erlbaum Associates. Chapter 3.
}
\keyword{internal}
