% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{DepthCor}
\alias{DepthCor}
\title{Plot sequencing depth correlation}
\usage{
DepthCor(object, assay = NULL, reduction = "lsi", n = 10, ...)
}
\arguments{
\item{object}{A \code{\link[SeuratObject]{Seurat}} object}

\item{assay}{Name of assay to use for sequencing depth. If NULL, use the
default assay.}

\item{reduction}{Name of a dimension reduction stored in the
input object}

\item{n}{Number of components to use. If \code{NULL}, use all components.}

\item{...}{Additional arguments passed to \code{\link[stats]{cor}}}
}
\value{
Returns a \code{\link[ggplot2]{ggplot}} object
}
\description{
Compute the correlation between total counts and each reduced
dimension component.
}
\examples{
\donttest{
DepthCor(object = atac_small)
}
}
\concept{visualization}
