% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Tabu_searchprep.R
\name{search.prep}
\alias{search.prep}
\title{Given a fitted lavaan model (e.g., CFA), prepares a table that contains
parameters that can be fixed/freed as part of a model specification search.}
\usage{
search.prep(fitted.model, loadings = TRUE, fcov = TRUE, errors = FALSE)
}
\arguments{
\item{fitted.model}{- an object of class "lavaan" that contains the initially fitted model for the search}

\item{loadings}{- a logical value that indicates whether cross-loadings will be part of the search}

\item{fcov}{- a logical value indicating whether factor covariances will be part of the search}

\item{errors}{- a logical value indicating whether error covariances will be part of the search}
}
\value{
A \code{data.frame} with lavaan-formatted parameter values.
}
\description{
Given a fitted lavaan model (e.g., CFA), prepares a table that contains
parameters that can be fixed/freed as part of a model specification search.
}
\examples{
\dontrun{
# load simulation data and select columns used in this example
data(simulated_test_data)
tabuData <- simulated_test_data[, c(1:10)]

# specify an improper model (improper because data is unidimensional)
tabuModel <- "
Ability =~ Item1 + Item2 + Item3 + Item4
FakeAbility =~ Item5 + Item6 + Item7 + Item8
Ability ~ Outcome
FakeAbility ~ 0*Outcome"

# run the initial misspecified model for Tabu

init.model <- lavaan::lavaan(
  model = tabuModel, data = tabuData,
  auto.var = TRUE, auto.fix.first = FALSE, std.lv = TRUE, auto.cov.lv.x = TRUE
)

# Use search.prep to prepare for the Tabu search
ptab <- search.prep(fitted.model = init.model, loadings = TRUE, fcov = TRUE, errors = FALSE)

# add an additional (mispecified) parameter
additional.param <- "Item1 ~~ 0.5*Item3"
ptab <- add.param(fitted.model = init.model, ptab = ptab, syntax = additional.param)

# Perform Tabu Search
trial <- tabu.sem(init.model = init.model, ptab = ptab, obj = AIC, niter = 2, tabu.size = 5)
}
}
\references{
\doi{10.1080/10705511.2017.1409074}
}
\seealso{
Other Tabu Search: 
\code{\link{add.param}()},
\code{\link{refit.model}()}
}
\author{
Carl F. Falk
}
\concept{Tabu Search}
