% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blis.R
\docType{class}
\name{BlisClass-class}
\alias{BlisClass-class}
\title{BLIS S4 class}
\description{
Extends \code{mirt}'s \code{SingleGroupClass} directly (meaning all \code{mirt} methods that
work with that class will work with \linkS4class{BlisClass} too; make sure \code{mirt} is
loaded).
}
\details{
The purpose of the class is to have a custom \code{coef} method  (see
\link{coef,BlisClass-method}) dispatched and the original levels with correct
response (as a \code{key} attribute) stored in the resulting fitted model.
}
\section{Slots}{

\describe{
\item{\code{orig_levels}}{\emph{list} of original levels with logical attribute \code{key},
which stores the information on which response (level) has been considered
as correct. Note that levels not used in the original data are dropped.}
}}

\seealso{
Other BLIS/BLIRT related: 
\code{\link{coef,BlisClass-method}},
\code{\link{fit_blis}()},
\code{\link{get_orig_levels}()},
\code{\link{nominal_to_int}()},
\code{\link{obtain_nrm_def}()},
\code{\link{print.blis_coefs}()}
}
\concept{BLIS/BLIRT related}
