% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing5.R
\name{FetchResidualSCTModel}
\alias{FetchResidualSCTModel}
\title{Calculate pearson residuals of features not in the scale.data
This function is the secondary function under FetchResiduals}
\usage{
FetchResidualSCTModel(
  object,
  umi.object,
  layer = "counts",
  chunk_size = 2000,
  layer.cells = NULL,
  SCTModel = NULL,
  reference.SCT.model = NULL,
  new_features = NULL,
  clip.range = NULL,
  replace.value = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{object}{An SCTAssay object}

\item{umi.object}{The assay to use when recalculating any missing residuals.}

\item{layer}{The name of the layer(s) in `umi.object` to use when 
recalculating any missing residuals.}

\item{chunk_size}{Number of cells to load in memory for calculating
residuals}

\item{layer.cells}{Vector of cells to calculate the residual for.
Default is NULL which uses all cells in the layer}

\item{SCTModel}{Which SCTmodel to use from the object for calculating
the residual. Will be ignored if reference.SCT.model is set}

\item{reference.SCT.model}{If a reference SCT model should be used
for calculating the residuals. When set to not NULL, ignores the `SCTModel`
paramater.}

\item{new_features}{A vector of features to calculate the residuals for}

\item{clip.range}{Numeric of length two specifying the min and max values
the Pearson residual will be clipped to. Useful if you want to change the
clip.range.}

\item{replace.value}{Whether to replace the value of residuals if it
already exists}

\item{verbose}{Whether to print messages and progress bars}
}
\value{
Returns a matrix containing centered pearson residuals of
added features
}
\description{
Calculate pearson residuals of features not in the scale.data
This function is the secondary function under FetchResiduals
}
\keyword{internal}
