% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/differential_expression.R
\name{DESeq2DETest}
\alias{DESeq2DETest}
\title{Differential expression using DESeq2}
\usage{
DESeq2DETest(object, cells.1, cells.2, genes.use = NULL, assay.type = "RNA",
  ...)
}
\arguments{
\item{object}{Seurat object}

\item{cells.1}{Group 1 cells}

\item{cells.2}{Group 2 cells}

\item{genes.use}{Genes to use for test}

\item{assay.type}{Type of assay to fetch data for (default is RNA)}

\item{...}{Extra parameters to pass to DESeq2::results}
}
\value{
Returns a p-value ranked matrix of putative differentially expressed
genes.
}
\description{
Identifies differentially expressed genes between two groups of cells using
DESeq2
}
\details{
This test does not support pre-filtering of genes based on average difference
(or percent detection rate) between cell groups. However, genes may be
pre-filtered based on their minimum detection rate (min.pct) across both cell
groups. To use this method, please install DESeq2, using the instructions at
 https://bioconductor.org/packages/release/bioc/html/DESeq2.html
}
\examples{
\dontrun{
  pbmc_small
  DESeq2DETest(pbmc_small, cells.1 = WhichCells(object = pbmc_small, ident = 1),
              cells.2 = WhichCells(object = pbmc_small, ident = 2))
}

}
\references{
Love MI, Huber W and Anders S (2014). "Moderated estimation of
fold change and dispersion for RNA-seq data with DESeq2." Genome Biology.
https://bioconductor.org/packages/release/bioc/html/DESeq2.html
}
