% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_determination.R
\name{BuildClusterTree}
\alias{BuildClusterTree}
\title{Phylogenetic Analysis of Identity Classes}
\usage{
BuildClusterTree(object, genes.use = NULL, pcs.use = NULL, SNN.use = NULL,
  do.plot = TRUE, do.reorder = FALSE, reorder.numeric = FALSE,
  show.progress = TRUE)
}
\arguments{
\item{object}{Seurat object}

\item{genes.use}{Genes to use for the analysis. Default is the set of
variable genes (object@var.genes). Assumes pcs.use=NULL (tree calculated in
gene expression space)}

\item{pcs.use}{If set, tree is calculated in PCA space.}

\item{SNN.use}{If SNN is passed, build tree based on SNN graph connectivity between clusters}

\item{do.plot}{Plot the resulting phylogenetic tree}

\item{do.reorder}{Re-order identity classes (factor ordering), according to
position on the tree. This groups similar classes together which can be
helpful, for example, when drawing violin plots.}

\item{reorder.numeric}{Re-order identity classes according to position on
the tree, assigning a numeric value ('1' is the leftmost node)}

\item{show.progress}{Show progress updates}
}
\value{
A Seurat object where the cluster tree is stored in
object@cluster.tree[[1]]
}
\description{
Constructs a phylogenetic tree relating the 'average' cell from each
identity class. Tree is estimated based on a distance matrix constructed in
either gene expression space or PCA space.
}
\details{
Note that the tree is calculated for an 'average' cell, so gene expression
or PC scores are averaged across all cells in an identity class before the
tree is constructed.
}
\examples{
pbmc_small
pbmc_small <- BuildClusterTree(pbmc_small, do.plot = FALSE)

}
