% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_determination.R
\name{BuildRFClassifier}
\alias{BuildRFClassifier}
\title{Build Random Forest Classifier}
\usage{
BuildRFClassifier(object, training.genes = NULL, training.classes = NULL,
  verbose = TRUE, ...)
}
\arguments{
\item{object}{Seurat object on which to train the classifier}

\item{training.genes}{Vector of genes to build the classifier on}

\item{training.classes}{Vector of classes to build the classifier on}

\item{verbose}{Additional progress print statements}

\item{...}{additional parameters passed to ranger}
}
\value{
Returns the random forest classifier
}
\description{
Train the random forest classifier
}
\examples{
pbmc_small
# Builds the random forest classifier to be used with ClassifyCells
# Useful if you want to use the same classifier with several sets of new data
classifier <- BuildRFClassifier(pbmc_small, training.classes = pbmc_small@ident)

}
