% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test.hc.R
\name{test.hc}
\alias{test.hc}
\title{Multiple comparison test using Higher Criticism (HC) statitics.}
\usage{
test.hc(prob, M, k0, k1, LS = F, ZW = F, onesided = FALSE)
}
\arguments{
\item{prob}{- vector of input p-values.}

\item{M}{- correlation matrix of input statistics (of the input p-values).}

\item{k0}{- search range starts from the k0th smallest p-value.}

\item{k1}{- search range ends at the k1th smallest p-value.}

\item{LS}{- if LS = T, then method of Li and Siegmund (2015) will be implemented.When n and q is very large, approximation method is prefered.}

\item{ZW}{- if ZW = T, then approximation method of Zhang and Wu will be implemented.}

\item{onesided}{- TRUE if the input p-values are one-sided.}
}
\value{
pvalue - The p-value of the HC test.

hcstat - HC statistic.

location - the order of the input p-values to obtain HC statistic.
}
\description{
Multiple comparison test using Higher Criticism (HC) statitics.
}
\examples{
pval.test = runif(10)
test.hc(pval.test, M=diag(10), k0=1, k1=10)
test.hc(pval.test, M=diag(10), k0=1, k1=10, LS = TRUE)
test.hc(pval.test, M=diag(10), k0=1, k1=10, ZW = TRUE)
#When the input are statistics#
stat.test = rnorm(20)
p.test = 2*(1 - pnorm(abs(stat.test)))
test.hc(p.test, M=diag(20), k0=1, k1=10)
}
\references{
1. Hong Zhang, Jiashun Jin and Zheyang Wu. "Distributions and Statistical Power of Optimal Signal-Detection Methods In Finite Cases", submitted.

2. Donoho, David; Jin, Jiashun. "Higher criticism for detecting sparse heterogeneous mixtures". Annals of Statistics 32 (2004).

3. Li, Jian; Siegmund, David. "Higher criticism: p-values and criticism". Annals of Statistics 43 (2015).
}
\seealso{
\code{\link{stat.hc}} for the definition of the statistic.
}
