% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_zinb.R
\name{gen_zinb}
\alias{gen_zinb}
\title{Generate ZINB counts from an underlying network}
\usage{
gen_zinb(n, network, reference = NULL, params = NULL,
  library_sizes = NULL, adjust_library_size = NULL, verbose = TRUE)
}
\arguments{
\item{n}{The number of samples to generate.}

\item{network}{A 'network' object or list of 'network' objects.}

\item{reference}{Either a vector or data.frame of counts from a reference
gene expression profile. If a data.frame is provided, each column should
correspond to a gene. If both \code{reference} and \code{params} are 
\code{NULL}, then parameters are estimated from the kidney dataset.}

\item{params}{A matrix of ZINB parameter values; each column should contain 
the size, mu, and rho parameters for a gene.}

\item{library_sizes}{A vector of library sizes. Used only if \code{reference} is 
\code{NULL}.}

\item{adjust_library_size}{A boolean value. If \code{TRUE}, the library size of 
generated counts are adjusted based on the reference library sizes. If both 
\code{reference} and \code{library_sizes} is \code{NULL}, then no adjustment is made. 
By default, this adjustment is made if the necessary information is provided.}

\item{verbose}{Boolean indicator for message output.}
}
\value{
A list containing the generated counts and the ZINB parameters used
to create them. If a list of networks were provided, then the results for
each network are returned as a list.
}
\description{
The count data are generated based on the gene-gene associations of an
udnerlying network. An association structure is imposed by first generating 
data from a multivariate Gaussian distribution, and counts are then obtained
through the inverse tranformation method. To generate realistic counts, either 
a reference dataset or parameters for the ZINB model (size, mu, rho) can be 
provided. Parameters can be estimated from a reference using the
\code{\link{est_params_from_reference}} function.
}
\examples{
nw <- random_network(10) # Create a random network with 10 nodes.
nw <- gen_partial_correlations(nw) # Add weights to connections in the network.
# If no reference is provided, ZINB data are generated using an internal reference.
x <- gen_zinb(20, nw)$x # Simulate 20 ZINB observations from the network.
}
