% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{loadImdb}
\alias{loadImdb}
\title{Retrieves IMDb dataset}
\usage{
loadImdb()
}
\value{
Returns a list where entry named \code{Corpus} contains the IMDb reviews,
and \code{Rating} is the corresponding scaled rating.
}
\description{
Function downloads IMDb dataset and prepares corresponding user ratings for easy
usage.
}
\examples{
\dontrun{
imdb <- loadImdb()
dictionary <- generateDictionary(imdb$Corpus, imdb$Rating)
}
}
\references{
Pang and Lee (2015) \emph{Seeing Stars: Exploiting Class Relationships 
for Sentiment Categorization with Respect to Rating Scales}, Proceeding of the 
ACL. See \url{http://www.cs.cornell.edu/people/pabo/movie-review-data/}
}
\keyword{datasets}
