% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SemanticNetworkCleaner.R
\name{autoDeStr}
\alias{autoDeStr}
\title{Automated De-string Responses}
\usage{
autoDeStr(rmat, char = 10)
}
\arguments{
\item{rmat}{A semnetcleaner filtered response matrix}

\item{char}{Minimum number of characters in a string to be checked for \link[SemNetCleaner]{destr}.
Defaults to 10}
}
\value{
A question asking whether the response should be de-string-ed.
If yes, \link[SemNetCleaner]{destr} will be applied.
If no, the next response will be checked
}
\description{
Automated de-string responses after performing semnetcleaner
}
\examples{
#create example stringed responses
stringed <- cbind(rowSums(cbind(rmat[,c(1,2)])),convmat)
#change name to stringed name
colnames(stringed)[1] <- "alligator.ant"

\donttest{
#automated de-string
convmat <- destr(stringed, 10)
}
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
