% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/aad.R
\encoding{UTF-8}
\name{aad}
\alias{aad}
\title{Average Absolute Deviation}
\usage{
aad(x, na.rm = TRUE, ...)
}
\arguments{
\item{x}{A numeric vector containing the observations.}

\item{na.rm}{A logical value for \code{na.rm}, default is \code{na.rm=TRUE}.}

\item{\dots}{Additional arguements (currently ignored)}
}
\description{
Calculates the average (mean) absolute deviation from the sample mean.
}
\details{
The statistical literature has not yet adopted a standard notation for  the "Mean Absolute Deviation" and the "Median Absolute Deviation". As a result, both statistics have been denoted as "MAD", which may lead to confusion once they may produce different values.
The R \code{\link[stats]{mad}} by default computes the "Median Absolute Deviation"; to obtain the "Mean Absolute Deviation" one has to use \code{mad(x, constant = 1)}.
Thus, the function \code{\link[SciencesPo]{aad}} will calculate the "Mean Absolute Deviation"--or "Average Deviation (AD)" as proposed by Garrett, who defines it as "the mean of the deviation of all the separate scores in the series taken from their mean (occasionally from the median or mode)", (1971, p. 481).
}
\examples{
x <- c(15, 10, 6, 8, 11)
aad(x)
}
\author{
Daniel Marcelino, \email{dmarcelino@live.com}
}
\references{
Garrett, Henry (1982) \emph{Statistics in Psychology and Education}. 6th, Paragon.
}
\seealso{
\code{\link[stats]{mad}}
}
\keyword{Exploratory}

