% Generated by roxygen2 (4.0.2): do not edit by hand
\name{margins}
\alias{margins}
\title{Puts Arbitrary Margins on Two-way Tables or Arrays}
\usage{
margins(table, margin = seq_along(dim(table)), ...)
}
\arguments{
\item{table}{an array or a table class object.}

\item{margin}{A numeric value over which to form margins.  See details.}

\item{\dots}{Additional arguments to be sent to \code{addmargins}.  See \code{?addmargins}.}
}
\value{
A table or array with the same number of dimensions as \code{A}, but
with extra levels of the dimensions mentioned in \code{margin}.
}
\description{
Used to put marginal values on the two-way table or array.  For tables or
arrays with more dimensions see \code{addmargins()}.  This version is
designed for use in introductory classes where the \code{margin=} argument
has been modified to be more intuitive to students.  Specifically, This function
is a pass-through to \code{addmargins()} with the exception that \code{margin=1}
adds a marginal value at the end of the rows and \code{margin=2} adds a marginal
value at the end of the columns.  The numeric values in \code{margin=} are opposite
of what is used in \code{addmargins()}.
}
\note{
This is primarily a wrapper function for \code{addmargins} in \pkg{stats}.
}
\examples{
Aye <- sample(c("Yes", "Si", "Oui"), 177, replace = TRUE)
( A1 <- table(Aye) )
Bee <- sample(c("Hum", "Buzz"), 177, replace = TRUE)
( A2 <- table(Aye, Bee) )

## 1-D table
# Add sums to margin
margins(A1)
# Add sums to margin of proportions table
margins(prop.table(A1))

## 2-D table
# Add sums to all margins
margins(A2)

# Add sums to end of rows (row totals)
margins(A2,margin=1)

# Add sums to end of columns (column totals)
margins(A2,margin=2)

# Add sums to end of a row proportions table
A2.row <- prop.table(A2,margin=1)
margins(A2.row, margin=1)

# Add sums to end of a column proportions table
A2.col <- prop.table(A2,margin=2)
margins(A2.col,margin=2)
# Add sums to all margins of proportions table
A2.tbl <- prop.table(A2)
margins(A2.tbl)
}
\seealso{
and \code{percTable} in \pkg{NCStats}.
}
\keyword{array}
\keyword{manip}

