% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svem_significance_test_parallel.R
\name{svem_significance_test_parallel}
\alias{svem_significance_test_parallel}
\title{SVEM Significance Test with Mixture Support (Parallel Version)}
\usage{
svem_significance_test_parallel(
  formula,
  data,
  mixture_groups = NULL,
  nPoint = 2000,
  nSVEM = 5,
  nPerm = 125,
  percent = 85,
  nBoot = 200,
  glmnet_alpha = c(1),
  weight_scheme = c("SVEM"),
  objective = c("wAIC", "wSSE"),
  verbose = TRUE,
  nCore = parallel::detectCores(),
  seed = NULL,
  ...
)
}
\arguments{
\item{formula}{A formula specifying the model to be tested.}

\item{data}{A data frame containing the variables in the model.}

\item{mixture_groups}{Optional list describing one or more mixture factor
groups.  Each element of the list should be a list with components
`vars` (character vector of column names), `lower` (numeric vector of
lower bounds of the same length as `vars`), `upper` (numeric vector
of upper bounds of the same length), and `total` (scalar specifying the
sum of the mixture variables).  All mixture variables must be
included in `vars`, and no variable can appear in more than one
mixture group.  Defaults to `NULL` (no mixtures).}

\item{nPoint}{Number of random points in the factor space (default: 2000).}

\item{nSVEM}{Number of SVEM fits on the original data (default: 5).}

\item{nPerm}{Number of SVEM fits on permuted responses for the reference
distribution (default: 125).}

\item{percent}{Percentage of variance to capture in the SVD (default: 85).}

\item{nBoot}{Number of bootstrap iterations within each SVEM fit (default: 200).}

\item{glmnet_alpha}{The alpha parameter(s) for glmnet (default: `c(1)`).}

\item{weight_scheme}{Weighting scheme for SVEM (default: "SVEM").}

\item{objective}{Objective function for SVEM ("wAIC" or "wSSE", default: "wAIC").}

\item{verbose}{Logical; if `TRUE`, displays progress messages (default: `TRUE`).}

\item{nCore}{Number of CPU cores for parallel processing (default: all available cores).}

\item{seed}{Optional integer seed for reproducible parallel RNG (default: NULL).}

\item{...}{Additional arguments passed to `SVEMnet()` and then to `glmnet()`.}
}
\value{
A list of class `svem_significance_test` containing the test results.
}
\description{
Whole-model significance test using SVEM with support for mixture factor groups,
parallelizing the SVEM fits for originals and permutations.
}
\details{
Identical to \code{svem_significance_test()} but runs the expensive
SVEM refits in parallel using \code{foreach} + \code{doParallel}. Random draws
(including permutations) use \code{RNGkind("L'Ecuyer-CMRG")} for parallel-suitable streams.
}
\seealso{
svem_significance_test svem_significance_test_parallel
}
