% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/divide_samples.R,
%   R/divide_samples_alternative.R
\name{divide_samples}
\alias{divide_samples}
\title{Global Variable}
\usage{
divide_samples(n_samples, num, min_size)

divide_samples(n_samples, num, min_size)
}
\arguments{
\item{n_samples}{Integer. Total number of samples to divide.}

\item{num}{Integer. Number of desired segments or latent factors.}

\item{min_size}{Integer. Minimum size (length) allowed for each segment.}
}
\value{
A list of integer vectors. Each vector contains a sequence of indices
representing a subsample of the corresponding segment.
}
\description{
A global variable used in multiple functions.

This utility function divides a sequence of sample indices into \code{num} segments
ensuring that each segment meets a specified minimum size. It optionally
extracts a subset of each segment based on predefined selection logic:
\itemize{
\item For a single group (\code{num = 1}): selects a random contiguous sub-vector
comprising between 10\% and 55\% of the total samples.
\item For multiple groups (\code{num > 1}): selects a contiguous sub-vector
comprising approximately 75\% of each segment.
}
}
\details{
This function is primarily used for randomized simulation of sample blocks,
useful in bootstrapping, subsampling, or simulating latent factor scores
across multi-omics datasets.
}
\examples{
divide_samples(n_samples = 100, num = 3, min_size = 10)
divide_samples(n_samples = 50, num = 1, min_size = 5)

}
