% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quality_functions.R
\name{phredQualityProbability}
\alias{phredQualityProbability}
\alias{solexaQualityProbability}
\title{Quality score to probability}
\usage{
phredQualityProbability(q)

solexaQualityProbability(q)
}
\arguments{
\item{q}{Quality score.}
}
\value{
\code{phredQualityScore(q_phred)} and \code{solexaQualityScore(q_solexa)} returns a probability of error.
}
\description{
Converts a quality score (Phred or Solexa) to a probability of error.
}
\examples{
q_phred = phredQualityScore(1e-3)
q_solexa = solexaQualityScore(1e-3)

phredQualityProbability(q_phred)
solexaQualityProbability(q_solexa)
}
