% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_distances_boxplot.R
\name{plot_distance_boxplot}
\alias{plot_distance_boxplot}
\title{Visualize Nearest Neighbor Distances with Boxplot and Mean ± SEM}
\usage{
plot_distance_boxplot(
  distance_result,
  id_col = "barcode",
  show_points = FALSE,
  y_scale = c("original", "log10"),
  palette = "Set2"
)
}
\arguments{
\item{distance_result}{A data.frame generated by \code{calculate_nearest_distances()},
containing distance measurements with columns: id_col + target_types.}

\item{id_col}{Name of the column containing cell IDs (default: "barcode").}

\item{show_points}{Logical, whether to overlay individual data points (default: FALSE).}

\item{y_scale}{Method for y-axis scaling: "original" or "log10" (default: "original").}

\item{palette}{Color palette name from \code{RColorBrewer} (default: "Set2").}
}
\value{
A ggplot2 object. Additional customization can be done using ggplot2 functions.
}
\description{
Creates a boxplot visualization of distance metrics with overlaid mean points
and SEM error bars. Suitable for comparing multiple groups with potentially
skewed distributions.
}
\examples{
plot_distance_boxplot(distance_results,id_col = "Newbarcode")
}
