% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcgroup.R
\name{calcgroup}
\alias{calcgroup}
\title{Calculates sociometric status determinations of a specified single group
from a SSrat compliant dataframe}
\usage{
calcgroup(schoolid = 1, groupid = 1, dataframe, scalelength = c(5, 3, 7,
  9), alpha = c(0.1, 0.05, 0.01), NBcriteria = F, printresult = F)
}
\arguments{
\item{schoolid}{The schoolnumber that identifies the school. Default = 1.}

\item{groupid}{The groupnumber that identifies the group. Default = 1.}

\item{dataframe}{The dataframe with the rating data. This dataframe should
have columns schoolid, groupid, respid, and for n raters columns r01 to rn,
with a maximum of r99. Function readratdatfixed can be used to create such a
dataframe from a prepared text file.}

\item{scalelength}{Either 3, 5, 7 or 9. Default = 5.}

\item{alpha}{The significance levels to be applied to the probability
distributions of the four total scores that have been derived from the
ratings. By choosing an appropriate alpha, the user can fine tune the
criterion for the status determination. A list of various alphas can be
supplied. Default is the list (.10, .05, .01).}

\item{NBcriteria}{A boolean. When TRUE, the classification criteria of
Newcomb & Bukowski (1983) will be applied, in stead of the SSrat criteria.
These criteria are applicable to rating scales of length 3. When this option
is selected with longer scales, the midscore is conversed to 2, alls cores
larger than the midscore are conversed to 3 and all scores lower than the
midscore are conversed to 1. When another recoding scheme of the scores is
preferred, the input ratings should be recoded to 1, 2 and 3 before the use
of this function (use \code{car::recode}).}

\item{printresult}{Boolean which identifies whether the calculated results
should be shown. Default is False.}
}
\value{
\item{dataframe}{dataframe with the most relevant results, as
calculated for each respondent by SSrat} \item{dataframe$schoolid}{school id
as entered} \item{dataframe$groupid}{group id as entered}
\item{dataframe$respid}{respondent id as entered}
\item{dataframe$nrAss}{number of assessors who have given a valid rating}
\item{dataframe$tr.S}{total rating Sympathy} \item{dataframe$tr.A}{total
rating Antipathy} \item{dataframe$tr.P}{total rating Preference}
\item{dataframe$tr.I}{total rating Impact} \item{dataframe$SS.xx}{Social
Determination as attributed by SSrat, applying alpha = .xx. Defaults to
SS.10, SS.05 and SS.01 } \item{S}{matrix of Sympathy ratings}
\item{A}{matrix of Antipathy ratings} \item{P}{matrix of Preferences}
\item{I}{matrix of Impact scores} \item{intermediate$pls}{probability
referring to left-sided testing of tr.S} \item{intermediate$prs}{probability
referring to right-sided testing of tr.S} \item{intermediate$es}{expected
value of tr.S} \item{intermediate$pla}{probability referring to left-sided
testing of tr.A} \item{intermediate$pra}{probability referring to
right-sided testing of tr.A} \item{intermediate$ea}{expected value of tr.A}
\item{intermediate$plp}{probability referring to left-sided testing of tr.P}
\item{intermediate$prp}{probability referring to right-sided testing of
tr.P} \item{intermediate$ep}{expected value of tr.P}
\item{intermediate$pli}{probability referring to left-sided testing of tr.I}
\item{intermediate$pri}{probability referring to right-sided testing of
tr.I} \item{intermediate$ei}{expected value of tr.I}
}
\description{
In a group, all group members are asked to rate all other group members on a
rating scale. This rating scale can have 3 (1..3), 5 (1..5), 7 (1..7) or 9
(1..9) rating points. The rating scale has a neutral mid point (respectively
2, 3, 4 and 5). \cr Application of SSrat::calcgroup calculates a
classification into five categories of sociometric status, which is labeled
as follows: (1) popular, (2) rejected, (3) negelected, (4) controversial and
(5) average.
}
\details{
It is assumed that the data are gathered on a single (2R+1)-point rating
scale. For a 7-point scale, R = 3. The scale midpoint must represent a
neutral judgment. The data are arranged in a matrix P, with rows belonging
to assessors and columns belonging to the assessed.Let P[i, k] denote the
rating given by assessor i to group member k.\cr First P* scores are
calculated by subtracting R+1 from the values of P. The Sympathy scores S
are calculated by replacing all negative scores of P* by zero. The Antipathy
score A are calculated by replacing all positive scores of P* by zero and
taking the absolute value. P* = S - A.The Preference score P are equal to
the ratings obtained. The Impact scores I are calculated by taking the
absolute values of P*. I = S + A.\cr In the next step, sum scores are
calculated over columns. Then the distributions of these sumscores are
calculated, using the principle of convolution. Lastly, the positions in the
distributions are calculated to identify persons with scores in the areas of
the lower and higher alpha percent. This allows us to translate the criteria
of Coie et al. (1983) into probability terms. A person k obtains the
following social determinations (E is expected value): Popular = sum(P[,k])
significantly high, sum(S[,k]) > E(sum(S[,k])) and sum(A[,k]) <
E(sum(A[,k])); Rejected = sum(P[,k]) significantly low, sum(S[,k]) <
E(sum(S[,k])) and sum(A[,k]) > E(sum(A[,k])); Neglected = sum(I[,k])
significantly low, sum(S[,k]) < E(sum(S[,k])) and sum(A[,k]) <
E(sum(A[,k])); Controversial = sum(I[,k]) significantly high, sum(S[,k]) >
E(sum(S[,k])) and sum(A[,k]) > E(sum(A[,k])); Average = remaining group
members.

When the criteria of Newcomb & Bukowski (1993) are applied, the most liked
nominations LM are the ratings > R and the least liked nominations LL are
the ratings < R, and the impact score SI = LM + LL. The criteria for a
person k are: Popular = sum(LM[,k]) significantly high, sum(LL[,k]) <
E(sum(LL[,k])); Rejected = sum(LL[,k]) significantly high, sum(LM[,k]) <
E(sum(LM[,k])); Neglected = sum(SI[,k]) significantly low; Controversial =
sum(LM[,k]) significantly high and sum(LL[,k] > E(sum(LL[,k])) or
sum(LL[,k]) significantly high and sum(LM[,k] > E(sum(LM[,k])); Average =
remaining group members.
}
\examples{

data(example5.rat)
# calc SSRAT results fot this group
out =calcgroup (school=1, group=23, data=example5.rat, scalelength="3")
out$dataframe

# calc Newcomb & Bukowski results for this group
out =calcgroup (school=1, group=23, data=example5.rat, scalelength="3", NBcriteria=TRUE)
out$dataframe

# calc Newcomb & Bukowski results for example1
data(example1.rat)
out =calcgroup (school=1, group=1, data=example1.rat, scalelength="7", NBcriteria=TRUE)
out$dataframe

# calc SSrat results for example1
out =calcgroup (school=1, group=1, data=example1.rat, scalelength="7")
out$dataframe

}
\references{
Coie, J.D., & Dodge, K.A. (1983). Continuities and changes in
children's social status: A five-year longitudinal study. Merril-Palmer
Quarterly, 29, 261-282.\cr Newcomb, A. F., & Bukowski, W. M. (1983). Social
impact and social preference as determinants of children's peer group
status. Developmental Psychology, 19, 856-867.\cr Maassen, G. H. and
Landsheer, J. A. (1998). SSRAT: The processing of rating scales for the
determination of two-dimensional sociometric status. Behavior Research
Methods Instruments &amp; Computers, 30(4), 674-679.
}
\seealso{
\code{\link{readratdatafixed}}
}
\author{
Hans Landsheer
}
\keyword{List}
\keyword{list}
