% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSRA.R
\name{SSRA}
\alias{SSRA}
\title{Sakai Sequential Relation Analysis}
\usage{
SSRA(dat, r.crt = 0.3, mu.sq = 0, mu.eq = Inf, d.sq = 0.2, d.eq = 0.2,
  pairwise = TRUE, method = c("pearson", "kendall", "spearman"), alpha = 0.05,
  p.adjust.method = c("holm", "hochberg", "hommel",
                      "bonferroni", "BH", "BY", "fdr", "none"),
  digits = 3, vnames = TRUE, order = c("no", "decreasing", "increasing"),
  exclude = TRUE, output = TRUE)
}
\arguments{
\item{dat}{requires a data frame with polytomous data}

\item{r.crt}{correlation coefficient criterion to be judged 'sequential' or 'equivalent}

\item{mu.sq}{Absolute mean difference criterion to be judged 'sequential'}

\item{mu.eq}{maximal absolute mean difference to be judged 'equivalent'}

\item{d.sq}{effect size for mean difference criterion to be judged 'sequential'}

\item{d.eq}{maximal effect size Cohen's d to be judged 'equivalent'}

\item{pairwise}{pairwise deletion of missing data,
if \code{pairwise = FALSE} listwise deletion is applied}

\item{method}{character string indicating which correlation coefficient to be used,
  'pearson' = Pearson's product moment correlation coefficien
'spearman' = Spearman's rho statistic
'kendall' = Kendall's tau (default)}

\item{alpha}{significance level}

\item{p.adjust.method}{p-value correction method for multiple comparisons, see: ?p.adjust (default = holm)}

\item{digits}{integer indicating the number of decimal places to be used}

\item{vnames}{use variable names for labeling?}

\item{order}{sort by item mean of j and k?}

\item{exclude}{exclude paths with no relationship?}

\item{output}{print result table?}
}
\value{
Returns an object of class \code{ssra}, to be used for the \code{seqtable} function. The object is a list with
following entries: 'dat' (data frame), 'call" (function call), 'args' (specification of arguments),
'time' (time of analysis), 'R' (R version), 'package' (package version), and 'restab' (result table).
The 'restab' entry has following entries:
\tabular{ll}{
    \code{j}     	    \tab item j \cr
    \code{k}     	    \tab item k \cr
    \code{n}				    \tab sample size \cr
    \code{j.mean}	    \tab mean of item j \cr
    \code{j.sd}        \tab standard deviation of item j \cr
    \code{k.mean}      \tab mean of item k \cr
    \code{k.sd}        \tab standard deviation of item k \cr
    \code{r}	   	      \tab correlation coefficient \cr
    \code{r.t}	  	    \tab test statistic of the statistical significanc test for the correlation coefficient \cr
    \code{r.p}         \tab statistical significance value of the correlation \cr
    \code{r.sig}       \tab statistical significance of the correlation (0 = not significant / 1 = significant) \cr
    \code{r.crt}       \tab correlation criterion for judging 'sequential' or 'equal': 'r.p < alpha' and 'r > r.crt' (0 = no / 1 = yes) \cr
    \code{m.diff}	    \tab mean difference \cr
    \code{sd.diff}     \tab standard deviation difference \cr
    \code{m.diff.eff}  \tab effect size Cohen's d for dependent samples \cr
    \code{m.t}			    \tab test statistic of the statistical significanc test for mean difference \cr
    \code{m.p}    	    \tab statistical significance value of the mean difference \cr
    \code{m.sig} 	    \tab statistical significance of the mean difference (0 = not significant / 1 = significant) \cr
    \code{m.crt.sq}    \tab mean difference criteria for judging 'sequential': 'm.diff.p < alpha', 'm.diff > mu.sq' and 'm.diff.eff > d.sq'
                            (0 = no / -1 = yes negative / 1 = yes postive) \cr
    \code{m.crt.eq}    \tab mean difference criteria for judging 'equivalence':
                            statistical significant and 'm <= mu.eq' 'd <= d.sq'
                            (0 = no 1 = yes) \cr
    \code{seq}         \tab sequential relation of item pairs ("+","-", "") \cr
    \code{eq}          \tab equivalence of item pairs ("=" or "") \cr
    \code{order}       \tab order structure of item pairs ("=", "+","-") \cr
 }
}
\description{
This function conducts Sakai Sequential Relation Analysis (SSRA) based on Sakai 2016.
}
\details{
In Sakai Sequential Relation Analysis (SSRA), a pair of items is judged 'sequential', if there is
a higher correlation and a bigger mean difference than defined criterions between the two items.
If there is a higher correlation and a smaller mean difference than defined criterions between the
two items, the relation of the two items is judged 'equal'.
}
\examples{
# Example data based on Takeya (1991)

# Sakai Sequential Relation Analysis
# ordering assesed according to the correlation coefficient and mean difference
SSRA(exdat)
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at},
Keiko Sakai \email{keiko.sakai@oit.ac.jp}
}
\references{
Takeya, M. (1991). \emph{A new test theory: Structural analyses for educational information}.
Tokyo: Waseda University Press.
}
\seealso{
\code{\link{seqtable}}, \code{\link{TSSA}}, \code{\link{plot.ssra}}, \code{\link{scatterplot}}
}

