% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accum_edges.R
\name{accum_edges}
\alias{accum_edges}
\title{Accumulate edge values downstream}
\usage{
accum_edges(
  edges,
  lsn_path,
  sum_col,
  acc_col,
  save_local = TRUE,
  overwrite = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{edges}{An \code{sf} object with LINESTING geometry created
using \code{\link{lines_to_lsn}}.}

\item{lsn_path}{Local pathname to a directory in character format
specifying where relationships.csv resides, which is created
using \code{link{lines_to_lsn}}.}

\item{sum_col}{Name of an existing column in \code{edges}
(character format) that contains the value to sum downstream.}

\item{acc_col}{Name of the new column in \code{edges} (character
format) where the accumulated \code{sum_col} values will be
stored (see details).}

\item{save_local}{Logical indicating whether the updated
\code{edges} should be saved to \code{lsn_path} in GeoPackage
format. Defaults to \code{TRUE}.}

\item{overwrite}{A logical indicating whether results should be
overwritten if \code{acc_col} already exists in \code{edges}
or edges.gpkg already exists in \code{lsn_path} and
\code{save_local = TRUE}.}

\item{verbose}{Logical. Indicates whether messages about the
function progress should be printed to the console. Defaults to
\code{TRUE}.}
}
\value{
An \code{sf} object representing edges in the LSN, with a
new \code{acc_col} column. If \code{save_local = TRUE},
\code{edges} is saved to \code{lsn_path} in GeoPackage (.gpkg)
format.
}
\description{
Accumulate (sum) edge values downstream in a
Landscape Network (LSN)
}
\details{
\code{accum_edges} sums (i.e. accumulates) numeric
values in \code{edges} downstream, from headwater or source
features to each network outlet feature (i.e. most downstream
line feature in each sub-network). Missing values are not allowed in
\code{sum_col} and should be replaced with 0, or any other
meaningful numeric value, prior to running
\code{accum_edges}. The \code{acc_col} returned contains the
sum of \code{sum_col} found in upstream edges, in addition the
the \code{sum_col} for the edge itself. As such, \code{acc_col}
represents the cumulative upstream sum of \code{sum_col} for the
downstream node of each line feature in \code{edges}.
}
\examples{
# Get temporary directory, where the example LSN will be stored
# locally.
temp_dir <- tempdir()

# Build the LSN. When working with your own data, lsn_path will be
# a local folder of your choice rather than a temporary directory.
edges <- lines_to_lsn(
  streams = MF_streams,
  lsn_path = temp_dir,
  snap_tolerance = 1,
  check_topology = FALSE,
  overwrite = TRUE,
  verbose = FALSE
)

# Accumulate RCA area (rcaAreaKm2) downstream and store in a new
# column named WArea_km2
edges <- accum_edges(
  edges = edges,
  lsn_path = temp_dir,
  sum_col = "rcaAreaKm2",
  acc_col = "WArea_km2",
  save_local = FALSE,
  overwrite = TRUE,
  verbose = FALSE
)

summary(edges$WArea_km2)
}
