% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.SSN2}
\alias{summary.SSN2}
\alias{summary.ssn_lm}
\alias{summary.ssn_glm}
\title{Summarize a fitted model object}
\usage{
\method{summary}{ssn_lm}(object, ...)

\method{summary}{ssn_glm}(object, ...)
}
\arguments{
\item{object}{A fitted model object from \code{\link[=ssn_lm]{ssn_lm()}} or \code{\link[=ssn_glm]{ssn_glm()}}.}

\item{...}{Other arguments. Not used (needed for generic consistency).}
}
\value{
A list with several fitted model quantities used to create
informative summaries when printing.
}
\description{
Summarize a fitted model object.
}
\details{
\code{summary.ssn()} creates a summary of a fitted model object
intended to be printed using \code{print()}. This summary contains
useful information like the original function call, residuals,
a coefficients table, a pseudo r-squared, and estimated covariance
parameters.
}
\examples{
# Copy the mf04p .ssn data to a local directory and read it into R
# When modeling with your .ssn object, you will load it using the relevant
# path to the .ssn data on your machine
copy_lsn_to_temp()
temp_path <- paste0(tempdir(), "/MiddleFork04.ssn")
mf04p <- ssn_import(temp_path, overwrite = TRUE)

ssn_mod <- ssn_lm(
  formula = Summer_mn ~ ELEV_DEM,
  ssn.object = mf04p,
  tailup_type = "exponential",
  additive = "afvArea"
)
summary(ssn_mod)
}
\seealso{
\link{print.SSN2}
}
