\name{createSSN}
\alias{createSSN}
\alias{igraphKamadaKawai}
\alias{iterativeTreeLayout}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Create an SpatialStreamnetwork Object
}
\description{
Generates a random tree structure, with observed and prediction locations, and
stores as an object of class \link{SpatialStreamNetwork-class}.
}
\usage{
createSSN(n, obsDesign, predDesign = noPoints, path, importToR = FALSE,
    treeFunction = igraphKamadaKawai)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{n}{
	A numeric vector, where the generated \code{SpatialStreamNetwork} object will consist
	of \code{length(n)} distinct random tree structures, with the \code{i}th tree
	structure consisting of \code{n[i]} straight line segments.
}
  \item{obsDesign}{
	A function representing a sampling strategy. It is used to select
	observation points on the network. Input obsDesign is required and
	cannot have value noPoints, as there must be at least one observed point generated.
	At present the only implemented designs are \link{binomialDesign},
	\link{systematicDesign}, \link{systematicDesign}, \link{poissonDesign} and
	\link{hardCoreDesign}. For further details, which will allow users to
	to write your their own design function, please see the \link[=binomialDesign]{design functions}.
}
  \item{predDesign}{
	A function having the same signature as the \code{obsDesign} input, but this
	time the function generates the prediction points. This defaults to noPoints,
	which generates no prediction points. Otherwise any of the design functions
	which can be used for input \code{obsDesign} can also be used for input
	\code{predDesign}.
}
  \item{path}{
	The path where the new .ssn directory is to be stored.
}
  \item{importToR}{
	If \code{TRUE} then a call to \code{importSSN} is made immediately and the
	imported \code{SpatialStreamNetwork} object is returned. If
	\code{FALSE} then no value is returned.
}
	\item{treeFunction}{
		An input function that is used to generate the tree structure. This
		function must have the signature
		\preformatted{
			function(n)}

		Where \code{n} is the desired number of edges for the generated network. This function must return a list with four entries. Entry \code{graph} must be an \code{igraph} object representing the generated network. Entry \code{locations} must be a numeric matrix giving the locations of all the points, in order. That is, the first row contains the coordinates for point 0, the second the coordinates for point 1, etc. Entry \code{initialPoint} gives the number of the inital point in that network.
		The two possible values for this input are \code{iterativeTreeLayout} and \code{igraphKamadaKawai}. \code{igraphKamadaKawai} is the default and uses the \code{graph.tree} function from the \code{\link{igraph}} package, with the Kamada-Kawai layout function. \code{iterativeTreeLayout} generates more natural looking tree structures but is slower and can fail to function.
	}
}
\details{
This function generates random tree structure using the \code{\link{igraph}}
package and then turns these into an \code{SpatialStreamNetwork} object
with prediction and observation sites generated by the \code{obsDesign}
and \code{predDesign} functions. The main difficulty is assigning
locations to the vertices of the random trees, in such a way that the result
has the sort of layout that we want. This is a graph layout / embedding problem,
more specifically a tree layout problem. For now we are using the \code{layout.kamada.kawai}
function of the \code{igraph} package to construct this layout. Unlike some of the other
layouts available, it still gives interesting layouts when applied to trees
(some of the others tend to give highly structured layouts for such a
simple graph. The downside is that it the resulting layout can have self
intersections, and often does.
}
\value{
An \code{SpatialStreamNetwork} object if \code{importToR} is \code{TRUE}, otherwise \code{NULL}.
}
\author{
Rohan Shah and Pascal Monestiez \email{support@SpatialStreamNetworks.com}
}
%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
	\code{\link{SimulateOnSSN}}, \code{\link{importSSN}}, \code{\link{igraph}}
}

\examples{

library(SSN)
#Simulate three networks, the first consisting of ten straight line segments,
#the second of 20 and the third of 30. There are two observed points on the first
#network, four on the second and six on the third. All the observed points are
#distributed uniformly. The default for prediction points is no prediction points.
ssn1 <- createSSN(c(10, 20, 30), obsDesign = binomialDesign(c(2,4,6)),
  path=paste(tempdir(),"/simulated1.ssn", sep = ""), importToR = TRUE)
#NOT RUN plot(ssn1)

#Same as above, but using iterativeTreeLayout
#set.seed(5)
#ssn2 <- createSSN(c(10, 20, 30), obsDesign = binomialDesign(c(2,4,6)),
#  path=paste(tempdir(),"/simulated2.ssn", sep = ""), importToR = TRUE, 
#  treeFunction = iterativeTreeLayout)
#NOT RUN plot(ssn2)

#Simulate the same number of line segments per network, but this time the observed
#points have the distribution of a Poisson process with rates 2, 1 and 0.5
#respectively. Again there are no prediction points.
#ssn3 <- createSSN(c(10, 20, 30), obsDesign = poissonDesign(c(2,1,0.5)),
#  path=paste(tempdir(),"/simulated3.ssn", sep = ""), importToR = TRUE)
#NOT RUN plot(ssn3)

#Simulate the same number of line segments per network, but this time the observed
#points have a hard-core process distribution. Two hundred points are placed on
#every network according to the binomial process, and then points are removed
#until every poir of points is at least a distance 0.5 apart on the first network,
#0.25 on the second and 0.1 on the third. Again there are no prediction points.
#ssn4 <- createSSN(c(10, 20, 30), obsDesign = hardCoreDesign(200, c(0.5, 0.25, 0.1)),
#  path=paste(tempdir(),"/simulated4.ssn", sep = ""), importToR = TRUE)
#NOT RUN plot(ssn4)

#This time there are the same number of observed points on each of the networks,
#but there are ten prediction sites on each network.
ssn5 <- createSSN(c(10, 20, 30), obsDesign = binomialDesign(c(2, 4, 6)),
  predDesign = binomialDesign(c(10, 10, 10)), 
  path=paste(tempdir(),"/simulated5.ssn", sep = ""),
  importToR = TRUE)
#NOT RUN plot(ssn5)

#This time the observed and prediction points are a regular grid, spacing 0.5
#ssn6 <- createSSN(c(10, 20, 30), obsDesign = systematicDesign(0.5),
#  predDesign = systematicDesign(0.5), 
#  path=paste(tempdir(),"/simulated6.ssn", sep = ""),
#  importToR = TRUE)
#NOT RUN plot(ssn6)

#Same as example number 5, but this time the observed (but not predicted) points
#are replicated twice with different time values
#ssn7 <- createSSN(c(10, 20, 30), obsDesign = binomialDesign(c(2, 4, 6), 
#  replications=2),
#  predDesign = binomialDesign(c(10, 10, 10)), 
#	path=paste(tempdir(),"/simulated7.ssn", sep = ""),
#  importToR = TRUE)
#NOT RUN plot(ssn7)

ssn1@obspoints@SSNPoints[[1]]@point.data
ssn5@obspoints@SSNPoints[[1]]@point.data

}

