% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSL.R
\name{sslMarkovRandomWalks}
\alias{sslMarkovRandomWalks}
\title{t-step Markov Random Walks}
\usage{
sslMarkovRandomWalks(xl, yl, xu, t = 10, dist.type = "Euclidean", k = 10,
  gamma = 1, improvement = 1e-04)
}
\arguments{
\item{xl}{a n * p matrix or data.frame of labeled data.}

\item{yl}{a n * 1 binary labels(1 or -1).}

\item{xu}{a m * p matrix or data.frame of unlabeled data.}

\item{t}{step size.}

\item{dist.type}{character string; this parameter controls the type of distance measurement.(see \code{\link{dist}} or \code{\link{pr_DB}}).}

\item{k}{an integer parameter controls a k-nearest neighbor graph.}

\item{gamma}{a numeric parameter  in the affinity matrix.}

\item{improvement}{numeric. Maximum allowed distance between computed parameters in two successive iterations at the steady state.}
}
\value{
a m * 1 integer vector representing the predicted labels  of  unlabeled data.
}
\description{
t-step Markov Random Walks
}
\details{
\code{sslMarkovRandomWalks} transmits known labels to unlabeled data by t-step Markov random walks.Parameters are estimated by  an EM algorithm.
}
\examples{
data(iris)
xl<-iris[c(1:20,51:70),-5]
xu<-iris[c(21:50,71:100),-5]
yl<-rep(c(1,-1),each=20)
yu<-sslMarkovRandomWalks(xl,yl,xu)
}
\author{
Junxiang Wang
}
\references{
Szummer, M., & Jaakkola, T. (2001). Partially labeled classification with M
random walks. Advances in Neural Information Processing Systems, 14.
}
\seealso{
\code{\link{pr_DB}} \code{\link{dist}}
}

