% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RbindAllCbindIdMatch.r
\name{CbindIdMatch}
\alias{CbindIdMatch}
\title{Combine several data frames by using id variables to match rows}
\usage{
CbindIdMatch(..., addName = names(x), sep = "_", idNames = sapply(x,
  function(x) names(x)[1]), idNames1 = idNames, addLast = FALSE)
}
\arguments{
\item{...}{Several data frames as several input parameters or a list of data frames}

\item{addName}{NULL or vector of strings used to name columns according to origin frame}

\item{sep}{A character string to separate when addName apply}

\item{idNames}{Names of a id variable within each data frame}

\item{idNames1}{Names of variables in first data frame that correspond to the id variable within each data frame}

\item{addLast}{When TRUE addName will be at end}
}
\value{
A single data frame
}
\description{
Combine several data frames by using id variables to match rows
}
\details{
The first data frame is the basis and the other frames will be matched by using id-variables. 
        The default id-variables are the first variable in each frame. Corresponding variables with 
        the same name in first frame is assumed. An id-variable is not needed if the number of rows 
        is one or the same as the first frame. Then the element of idNames can be set to a string 
        with zero length.
}
\examples{
zA=data.frame(idA=1:10,idB=rep(10*(1:5),2),
              idC=rep(c(100,200),5),idC2=c(100,rep(200,9)),idC3=rep(100,10),
              idD=99,x=round(rnorm(10),3),xA=round(runif(10),2))
zB=data.frame(idB=10*(1:5),x=round(rnorm(5),3),xB=round(runif(5),2))
zC=data.frame(idC=c(100,200),x=round(rnorm(2),3),xC=round(runif(2),2))
zD=data.frame(idD=99,x=round(rnorm(1),3),xD=round(runif(1),2))
CbindIdMatch(zA,zB,zC,zD)
CbindIdMatch(a=zA,b=zB,c=zC,d=zD,idNames=c("","idB","idC",""))
CbindIdMatch(a=zA,b=zB,c=zC,d=zD,idNames1=c("","idB","idC2",""))
CbindIdMatch(a=zA,b=zB,c=zC,d=zD,idNames1=c("","idB","idC3",""))
CbindIdMatch(zA,zB,zC,zD,addName=c("","bbb","ccc","ddd"),sep=".",addLast=TRUE)
try(CbindIdMatch(X=zA,Y=zA[,4:5],Z=zC,idNames=NULL)) # Error
CbindIdMatch(X=zA,Y=zA[,4:5],Z=zD,idNames=NULL)      # Ok since equal NROW or NROW==1
CbindIdMatch(list(a=zA,b=zB,c=zC,d=zD))              # List is alternative input
}
\seealso{
\code{\link{RbindAll}} (same example data)
}
\author{
Øyvind Langsrud
}
