#' Bitumen content
#'
#' Relationship between bitumen content and percentage air voids.
#' 
#' @docType data
#' 
#' @keywords datasets
#'
#' @format A data frame with 42 rows and 2 columns:
#' \describe{
#'   \item{Bitumen}{The bitumen content (by percentage weight) in the bitumen sample}
#'   \item{AirVoids}{The percentage of air voids, by volume}
#' }
#' @source 
#' Panda, R. P., Sudhanshu Sekhar Das, and P. K. Sahoo. 2018. 
#' Relation Between Bitumen Content and Percentage Air Voids 
#' in Semi Dense Bituminous Concrete.
#' \emph{Journal of The Institution of Engineers (India): Series A} 
#' \bold{99} (2): 327--32.
#' 
#' @usage 
#' data(Bitumen)
#' 
#' @examples
#' plot(AirVoids ~ Bitumen, data = Bitumen)

"Bitumen"

