% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/construct_funcs.R
\name{msiDataset}
\alias{msiDataset}
\title{Constructor for \link{msi.dataset-class} objects.}
\usage{
msiDataset(values, mz, rsize, csize, verbose = TRUE)
}
\arguments{
\item{values}{numeric matrix containing the peaks intensities. Rows represent
pixels and columns represent peaks.}

\item{mz}{array of m/z peaks values.}

\item{rsize}{geometric shape (number of rows) of image.}

\item{csize}{geometric shape (number of columns) of image.}

\item{verbose}{boolean (default = TRUE). Additional output.}
}
\value{
\link{msi.dataset-class} object.
}
\description{
\code{msiDataset} returns a \link{msi.dataset-class} object. It
contains information about the matched peaks intensities, the geometrical
dimensions of the mass spectral image, and the common m/z values.
}
\details{
Function used to construct the main object \code{\link{msi.dataset-class}}.
This object contains all the information about peaks intensities (intensity
matrix), the geometrical shape of the image (rows, columns), and the vector
of the common m/z values, generated during the peak matching process.
}
\examples{
## Load package
library("SPUTNIK")

## Create the msi.dataset-class object
sz <- c(5, 4)
numIons <- 20
x <- matrix(rnorm(prod(sz) * numIons), prod(sz), numIons)
mz <- sort(sample(100, numIons))
msiX <- msiDataset(x, mz, sz[1], sz[2])
}
\author{
Paolo Inglese \email{p.inglese14@imperial.ac.uk}
}
