% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildKrigingDACE.R
\name{daceObjfunc}
\alias{daceObjfunc}
\title{DACE objective function}
\usage{
daceObjfunc(theta, pars, what = "all")
}
\arguments{
\item{theta}{model parameters to be evaluated}

\item{pars}{model option list, as created with \code{\link{dacePrepareFit}}}

\item{what}{a string: "all" both the likelihood (f) and the model list (fit) will be returned, 
"f" and "fit specify to return only those.}
}
\value{
A list of two elements (which are NA if \code{what} is specified accordingly)\cr
	\code{f} likelihood \cr
	\code{fit} also a list list of model variables, with the following elements: 
		\item{\code{beta}}{ generalized least squares estimate}
		\item{\code{gamma}}{ correlation factors}
		\item{\code{sigma2}}{ maximum Likelihood estimate of the process variance}
		\item{\code{C}}{ Cholesky factor of correlation matrix}
		\item{\code{Ft}}{ Decorrelated regression matrix}
		\item{\code{G}}{ From QR factorization: Ft = Q*t(G)\cr}
}
\description{
Evaluate the fit of a certain set of model parameters (\code{theta}), and
get all relevant variables of the model.
}
\seealso{
\code{\link{buildKrigingDACE}} \code{\link{daceLikelihood}} \code{\link{daceEvalFit}}
}
\author{
The authors of the original DACE Matlab code are Hans Bruun Nielsen, Soren Nymand Lophaven and Jacob Sondergaard. \cr
Extension of the Matlab code by Tobias Wagner \email{wagner@isf.de}. \cr 
Porting and adaptation to R and further extensions by Martin Zaefferer \email{martin.zaefferer@fh-koeln.de}.
}
\keyword{internal}
