% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_df.R
\name{list_df}
\alias{list_df}
\title{Lists convert data frame}
\format{A data frame with 19 variables:
\describe{
\item{ScientificName}{The scientific name (the accepted name) includes the name and the date of the name}
\item{Synonyms}{Synonyms name, Latin}
\item{ChineseName}{Chinese name}
\item{CommonNames}{Common name}
\item{Kingdom}{Kingdom at taxonTree}
\item{Phylum}{Phylum at taxonTree}
\item{Class}{Class at taxonTree}
\item{Order}{Order at taxonTree}
\item{Family}{Family at taxonTree}
\item{Genus}{Genus at taxonTree}
\item{Species}{Species at taxonTree}
\item{Infraspecies}{Infraspecies at taxonTree}
\item{Distribution}{Distribution of species or infraspecies}
\item{Name}{Full name of reviewer in English or Chinese}
\item{Email}{Organization of the reviewer in  English or Chinese}
\item{Address}{Email address of the reviewer}
\item{Institution}{Address of the reviewer in  English or Chinese}
\item{References}{References}
\item{Download}{Download date}
}}
\source{
Visit the website \url{http://sp2000.org.cn/api/document} for more details.
}
\usage{
list_df(x)
}
\arguments{
\item{x}{\code{list} object, See \link{search_checklist} for more details.}
}
\description{
Checklist lists convert data frame.
}
\examples{
\dontrun{
apiKey <- "your apiKey"
queries <- c("025397f9-9891-40a7-b90b-5a61f9c7b597","04c59ee8-4b48-4095-be0d-663485463f21")
x1 <- search_checklist(query = queries, apiKey = apiKey)
x2 <- list_df(x1)
for(i in 1:length(x2$References)){
x2$References[[i]] <- as.matrix(x2$References[[i]])
x2$References[[i]] <- diag(x2$References[[i]])
x2$References[[i]] <- paste(x2$References[[i]][1:length(x2$References[[i]])], collapse = ";")
}
}
}
\author{
Liuyong Ding
}
