% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BNP.eq.R
\name{BNP.eq}
\alias{BNP.eq}
\title{Bayesian non-parametric model for test equating}
\usage{
BNP.eq(scores_x, scores_y, range_scores = NULL, design = "EG",
  covariates = NULL, prior = NULL, mcmc = NULL, normalize = TRUE)
}
\arguments{
\item{scores_x}{Vector.  Scores of form X.}

\item{scores_y}{Vector.  Scores of form Y.}

\item{range_scores}{Vector of length 2.  Represent the minimum and maximum scores in the test.}

\item{design}{Character.  Only supports 'EG' design now.}

\item{covariates}{Data.frame.  A data frame with factors, containing covariates 
for test X and Y, stacked in that order.}

\item{prior}{List.  Prior information for BNP model.}

\item{mcmc}{List.  MCMC information for BNP model.}

\item{normalize}{Logical.  Whether normalize or not the 
response variable. This is due to Berstein's polynomials. Default is TRUE.}
}
\value{
A 'BNP.eq' object, which is list containing the following items:

Y Response variable.

X Design Matrix.

fit DPpackage object. Fitted model with raw samples.

max_score Maximum score of test.

patterns A matrix describing the different patterns formed
        from the factors in the covariables.

patterns_freq The normalized frequency of each pattern.
}
\description{
The Bayesian nonparametric (BNP) approach (Ghoshand Ramamoorthi, 2003; Hjort et al., 2010) 
starts by focusing on spaces of distribution functions, so that uncertainty is expressed on F itself. 
The prior distribution p(F) is defined on the space F of all distribution functions defined on X . If X 
is an infinite set then F is infinite-dimensional, and the corresponding prior model 
p(F) on F is termed nonparametric. The prior probability model is also referred to
as a random probability measure (RPM), and it essentially corresponds to a distribution 
on the space of all distributions on the set X . Thus Bayesian nonparametric models 
are probability models defined on a function space (Muller and Quintana, 2004).

Gonzalez et al. (2015) proposed a Bayesian non-parametric approach for equating. The main
idea consists of introducing covariate dependent BNP models for a collection of 
covariate-dependent equating transformations

 \eqn{ \left\{ \boldsymbol{\varphi}_{\boldsymbol{z}_f, \boldsymbol{z}_t} (\cdot): 
           \boldsymbol{z}_f, \boldsymbol{z}_t \in \mathcal{L}
       \right\} 
  }
}
\details{
Lorem ipsum dolor sit amet, consectetur adipiscing elit. 
Vivamus finibus vitae eros quis dictum. Donec lacus risus, facilisis quis 
tincidunt et, tincidunt sed mi. Nullam ullamcorper eros est, sed 
fringilla metus volutpat eu. Etiam ornare nulla id lorem posuere, eu vehicula 
urna vestibulum. Quisque luctus, diam ac mattis faucibus, leo felis tincidunt urna, eu 
tempus massa neque nec nibh. Aliquam erat volutpat. Fusce tempor mattis enim quis pretium. 
Aliquam volutpat luctus felis, nec fringilla enim tincidunt sed. 
Nam nec leo quis erat lobortis vulputate ac at neque
}
\author{
Daniel Leon A. \email{dnacuna@mat.uc.cl}, Felipe Barrientos \email{afb26@stat.duke.edu}.
}
\references{
asdasd
}
\keyword{BNP}
\keyword{Bayesian}
\keyword{equating}
\keyword{equating,}
\keyword{non-parametrics,}

