% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knockoffs.R
\name{SNPknock.knockoffHMM}
\alias{SNPknock.knockoffHMM}
\title{Sample knockoff copies of a hidden Markov model.}
\usage{
SNPknock.knockoffHMM(X, pInit, Q, pEmit, seed = 123)
}
\arguments{
\item{X}{a matrix of size n-by-p containing the original variables.}

\item{pInit}{an array of length K, containing the marginal distribution of the states for the first variable.}

\item{Q}{an array of size (p-1,K,K), containing a list of p-1 transition matrices between the K states of the Markov chain.}

\item{pEmit}{an array of size (p,M,K), containing the emission probabilities for each of the M possible emission states, 
from each of the K hidden states and the p variables.}

\item{seed}{an integer random seed (default: 123).}
}
\value{
A matrix of size n-by-p containing the knockoff variables.
}
\description{
This function constructs knockoff copies of variables distributed as a hidden Markov model.
}
\details{
Each element of the matrix X should be an integer value between 0 and M-1.
The transition matrices contained in Q are defined with the same convention as in \link{SNPknock.knockoffDMC}.
The emission propability matrices contained in pEmit are defined such that \eqn{P[X_{j}=k|H_{j}=l]=\mathrm{pEmit}[j,k,l]},
where \eqn{H_j} is the latent variable associated to \eqn{X_j}.
}
\examples{
p=10; K=5; M=3;
pInit = rep(1/K,K)
Q = array(stats::runif((p-1)*K*K),c(p-1,K,K))
for(j in 1:(p-1)) { Q[j,,] = Q[j,,] / rowSums(Q[j,,]) }
pEmit = array(stats::runif(p*M*K),c(p,M,K))
for(j in 1:p) { pEmit[j,,] = pEmit[j,,] / rowSums(pEmit[j,,]) }
X = SNPknock.models.sampleHMM(pInit, Q, pEmit, n=20)
Xk = SNPknock.knockoffHMM(X, pInit, Q, pEmit)
   
}
\references{
Sesia et al., Gene Hunting with Knockoffs for Hidden Markov Models,
  arXiv:1706.04677 (2017).
  \href{https://statweb.stanford.edu/~candes/papers/HMM_Knockoffs.pdf}{https://statweb.stanford.edu/~candes/papers/HMM_Knockoffs.pdf}
}
\seealso{
Other knockoffs: \code{\link{SNPknock.knockoffDMC}}
}
