% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.smle.R
\name{plot.smle}
\alias{plot.smle}
\title{Plots to visualize SMLE screening}
\usage{
\method{plot}{smle}(x, num_path = NULL, label = TRUE, which_path = NULL, out_plot = 1, ...)
}
\arguments{
\item{x}{A \code{'smle'} object as the output from \code{\link{SMLE}()}.}

\item{num_path}{The number of top coefficients to be shown.
Default is equal to the number of features retained in the model.}

\item{label}{Logical flag for whether to label each curve with the feature index. Default is \code{TRUE}.}

\item{which_path}{A vector to control which features are shown in addition to the paths for the most significant coefficients.}

\item{out_plot}{A number from 1 to 5 indicating which plot is to be shown in the separate window; the default for solution path plot is "1".
See Description for plot labels 2-5.}

\item{...}{Additional arguments passed to the second plot.}
}
\value{
No return value.
}
\description{
This function returns two plot windows. By default, the first shows 
1) the solution path (estimated coefficient by iteration step) for 
the retained features.
By default, the second plot contains 4 plots to assess convergence:
2) log-likelihood,  
3) Euclidean distance between the current and the previous coefficient estimates,   
4) the number of tries in u-search (see details of \code{\link{SMLE}()}),  
and 5) the number of features changed in the current active set.
}
\examples{
\donttest{
set.seed(1)
Data <- Gen_Data(correlation = "CS")
fit <- SMLE(Y = Data$Y,X = Data$X, k = 20, family = "gaussian")
plot(fit)
}
}
