% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.smle}
\alias{predict.smle}
\alias{predict.selection}
\title{Prediction based on SMLE screening and selection}
\usage{
\method{predict}{smle}(object, newdata = NULL, ...)

\method{predict}{selection}(object, newdata = NULL, ...)
}
\arguments{
\item{object}{A \code{'smle'} or \code{'selection'} object.}

\item{newdata}{Matrix of new values for the features at which predictions are to be made using the final model 
from \code{\link{SMLE}} or \code{\link{smle_select}}. If omitted, the function returns the fitted 
response values based on the training data.}

\item{...}{Further arguments passed to \code{\link[stats]{predict.glm}}.}
}
\value{
A prediction vector. The length of the vector equals to the number of observations of the data fitted in.
}
\description{
This function returns the predicted response values for a fitted model of class \code{'smle'} or \code{'selection'}.
}
\examples{
set.seed(1)
Data_sim1<-Gen_Data(n= 200, p =1000, correlation="AR",family = "gaussian", num_ctgidx =5)
fit1<-SMLE(Data_sim1$Y,Data_sim1$X, family = "gaussian" , k=10)
predict(fit1,newdata= Data_sim1$X[10:20,])
fit1_s <- smle_select(fit1)
predict(fit1_s)


#Prediction example with influential categorical feature. 
set.seed(2)
Data_sim2<-Gen_Data(n= 220, p =1000, correlation="AR",family = "gaussian", num_ctgidx =5)
fit2<-SMLE(Data_sim2$Y[1:200],Data_sim2$X[1:200,], family = "gaussian" , k=10)
predict(fit2)
predict(fit2,newdata= Data_sim2$X[201:220,])





}
