% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sarimaSpec.R
\name{sarimaSpec}
\alias{sarimaSpec}
\title{Automatic Modeling of a Scalar Seasonal Time Series}
\usage{
sarimaSpec(
  zt,
  maxorder = c(2, 1, 3),
  maxsea = c(1, 1, 1),
  criterion = "bic",
  period = 12,
  output = FALSE,
  method = "CSS-ML",
  include.mean = TRUE
)
}
\arguments{
\item{zt}{T by 1 vector of an observed scalar time series without missing values.}

\item{maxorder}{Maximum order of \eqn{(p,d,q)}. \eqn{p} is the AR order, \eqn{d} the degree of differencing,
and \eqn{q} The MA order. Default value is (2,1,3).}

\item{maxsea}{Maximum order of \eqn{(P,D,Q)}. \eqn{P} is the seasonal AR order, \eqn{D} the degree of seasonal differencing,
and \eqn{Q} the seasonal MA order. Default value is (1,1,1).}

\item{criterion}{Information criterion used for model selection. Either AIC or BIC.
Default is "bic".}

\item{period}{Seasonal period. The default is 12.}

\item{output}{If TRUE it returns the differencing order, the selected order and the minimum
value of the criterion. Default is TRUE.}

\item{method}{Estimation method. See the arima command in R. Possible values are "CSS-ML", "ML", and "CSS".
Default is "CSS-ML".}

\item{include.mean}{Should the model include a mean/intercept term? Default is TRUE.}
}
\value{
A list containing:
\itemize{
   \item data - The time series. If any transformation is taken, "data" is the transformed series.
   \item order - Regular ARIMA order.
   \item sorder - Seasonal ARIMA order.
   \item period - Seasonal period.
   \item include.mean - Switch about including mean in the model.
}
}
\description{
Auto-model specification of a scalar seasonal time series. The period should be given.
}
\details{
ADF unit-root test is used to assess seasonal and regular differencing.
For seasonal unit-root test, critical value associated with pv = 0.01 is used.
}
\examples{
data(TaiwanAirBox032017)
output <- sarimaSpec(TaiwanAirBox032017[1:100,1])

}
