% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSA_MM.R
\name{SSA.MM}
\alias{SSA.MM}
\title{Estimation of single Michaelis-Menten constant using the stochastic simulation approximation}
\usage{
SSA.MM(method = T, time, species, enz, subs, MM, catal, tun = 2.4, std,
  nrepeat, jump = 1, burning = 0, MM_m = 1, MM_v = 1e+06)
}
\arguments{
\item{method}{method selection: T=TQ model, F=SQ model(default = T)}

\item{time}{observed time interval}

\item{species}{observed trajectory of product}

\item{enz}{enzyme concentration}

\item{subs}{substrate concentration}

\item{MM}{initial value of MM constant}

\item{catal}{true value of catalytic constant}

\item{tun}{tunning constant of MH algorithm (default=2.4)}

\item{std}{standard deviation of proposal distribution (if =0, caclulated by Opt. function)}

\item{nrepeat}{total number of iteration (default=10000)}

\item{jump}{length of distance (default =1)}

\item{burning}{lenth of burning period (default =0)}

\item{MM_m}{prior mean of gamma prior (default =1)}

\item{MM_v}{prior variance of gamma prior (default =10000)}
}
\value{
A vector of posterior samples of Michaelis-Menten constant
}
\description{
The function estimates single Michaelis-Menten constant using the likelihood function
with the stochastic simulation approximation method.
}
\details{
The function SSA.MM generates a set of MCMC simulation samples from the
conditional posterior distribution of Michaelis-Menten constant of enzyme kinetics
model. As the MM constant is only parameter to be estimated in the function the user
should assign catalytic constant as well as initial enzyme concentration and substrate
concentration. The prior information for the parameter can be given.
The turning constant (scale_tun) and standard deviation of proposal normal
distribution (sig) can be set to controlled proper mixing and acceptance ratio of
the parameter from the conditional posterior distribution. The posterior samples
are only stored with fixed interval according to set "jump" to reduce serial correlation.
The initial iterations are removed for convergence. The “burning” is set the length of
initial iterations. The diffusion approximation method is used for construction of
the likelihood.
}
\examples{
data("Chymo_low")
time1=Chymo_low[,1]
species1=Chymo_low[,2]
 Chymotrypsin.mm<-SSA.MM(method=TRUE,time=time1,species=species1,enz=4.4e+7,subs=4.4e+7
 ,MM=10000,catal=0.051,tun=2.4,std=8e+7 ,nrepeat=10000,jump=1
 ,burning=0,MM_m=1,MM_v=1e+10)
}
