% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SIR_bootstrap.R
\name{SIR_bootstrap}
\alias{SIR_bootstrap}
\title{Bootstrap SIR}
\usage{
SIR_bootstrap(Y, X, H = 10, B = 10, graph = TRUE, choice = "")
}
\arguments{
\item{Y}{A numeric vector representing the dependent variable (a response vector).}

\item{X}{A matrix representing the quantitative explanatory variables (bind by column).}

\item{H}{The chosen number of slices (default is 10).}

\item{B}{The number of bootstrapped samples to draw (default is 10).}

\item{graph}{A boolean that must be set to true to display graphics (default is TRUE).}

\item{choice}{the graph to plot: 
\itemize{
  \item "eigvals" Plot the eigen values of the matrix of interest.
  \item "estim_ind" Plot the estimated index by the SIR model versus Y.
  \item "" Plot every graphs (default).
}}
}
\value{
An object of class SIR_bootstrap, with attributes:
\item{b}{This is an estimated EDR direction, which is the principal eigenvector
of the interest matrix.}
\item{mat_b}{A matrix of size p*B that contains an estimation of beta in 
the columns for each bootstrapped sample.}
\item{n}{Sample size.}
\item{p}{The number of variables in X.}
\item{H}{The chosen number of slices.}
\item{call}{Unevaluated call to the function.}
\item{index_pred}{The index b'X estimated by SIR.}
\item{Y}{The response vector.}
}
\description{
Apply a single-index \eqn{SIR} on \eqn{B} bootstraped samples of \eqn{(X,Y)} with \eqn{H} slices.
}
\examples{
# Generate Data
set.seed(10)
n <- 500
beta <- c(1,1,rep(0,8))
X <- mvtnorm::rmvnorm(n,sigma=diag(1,10))
eps <- rnorm(n)
Y <- (X\%*\%beta)**3+eps

# Apply bootstrap SIR
SIR_bootstrap(Y, X, H = 10, B = 10)
}
