% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/var2.F.R
\name{var2.F}
\alias{var2.F}
\title{Two-Sample F-Test for Variance}
\usage{
var2.F(x, y, alternative = c("two.sided", "less", "greater"))
}
\arguments{
\item{x}{a length-\eqn{n} data vector.}

\item{y}{a length-\eqn{m} data vector.}

\item{alternative}{specifying the alternative hypothesis.}
}
\value{
a (list) object of \code{S3} class \code{htest} containing: \describe{
\item{statistic}{a test statistic.}
\item{p.value}{\eqn{p}-value under \eqn{H_0}.}
\item{alternative}{alternative hypothesis.}
\item{method}{name of the test.}
\item{data.name}{name(s) of provided sample data.}
}
}
\description{
Given two univariate samples \eqn{x} and \eqn{y}, it tests
\deqn{H_0 : \sigma_x^2 \left\lbrace =,\geq,\leq \right\rbrace \sigma_y^2\quad vs\quad H_1 : \sigma_x^2 \left\lbrace \neq,<,>\right\rbrace \sigma_y^2}.
}
\examples{
## CRAN-purpose small example
x = rnorm(10)
y = rnorm(10)
var2.F(x, y, alternative="g") ## Ha : var(x) >= var(y)
var2.F(x, y, alternative="l") ## Ha : var(x) <= var(y)
var2.F(x, y, alternative="t") ## Ha : var(x) =/= var(y)

\donttest{
## empirical Type 1 error 
niter   = 1000
counter = rep(0,niter)  # record p-values
for (i in 1:niter){
  x = rnorm(57)  # sample x from N(0,1)
  y = rnorm(89)  # sample y from N(0,1)
  
  counter[i] = ifelse(var2.F(x,y)$p.value < 0.05, 1, 0)
}

## print the result
cat(paste("\n* Example for 'var2.F'\n","*\n",
"* number of rejections   : ", sum(counter),"\n",
"* total number of trials : ", niter,"\n",
"* empirical Type 1 error : ",round(sum(counter/niter),5),"\n",sep=""))
}

}
\references{
\insertRef{snedecor_statistical_1996}{SHT}
}
\concept{variance}
