% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdfplot.R
\name{cdfplot}
\alias{cdfplot}
\title{Plot distribution of CDF}
\usage{
cdfplot(
  medianfit,
  precisionfit,
  lower = NA,
  upper = NA,
  ql = 0.025,
  qu = 0.975,
  median.dist = "best",
  precision.dist = "gamma",
  n.rep = 10000,
  n.X = 100,
  fontsize = 18
)
}
\arguments{
\item{medianfit}{The output of a \code{fitdist} command following elicitation
of the expert's beliefs about the population median.}

\item{precisionfit}{The output of a \code{fitdist} command following elicitation
of the expert's beliefs about the population precision.}

\item{lower}{lower limit on the x-axis for plotting.}

\item{upper}{upper limit on the x-axis for plotting.}

\item{ql}{lower quantile for the plotted pointwise credible interval.}

\item{qu}{upper quantile for the plotted pointwise credible interval.}

\item{median.dist}{The fitted distribution for the population median. Can be one of \code{"normal"},
\code{"lognormal"} or \code{"best"}, where \code{"best"} will select the best fitting out of 
normal and lognormal.}

\item{precision.dist}{The fitted distribution for the population precision. Can either be \code{"gamma"}
or \code{"lognormal"}.}

\item{n.rep}{The number of randomly sampled CDFs used to estimated the median
and credible interval.}

\item{n.X}{The number of points on the x-axis at which the CDF is evaluated.}

\item{fontsize}{Font size used in the plots.}
}
\description{
Plot the elicited pointwise median and credible interval for an uncertain population CDF
}
\examples{
\dontrun{
prfit <- fitprecision(interval = c(60, 70), propvals = c(0.2, 0.4), trans = "log")
medianfit <- fitdist(vals = c(50, 60, 70), probs = c(0.05, 0.5,  0.95), lower = 0)
cdfplot(medianfit, prfit)
 }
}
