% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitDirichlet.R
\name{feedbackDirichlet}
\alias{feedbackDirichlet}
\title{Calculate quantiles for the marginal distributions of a Dirichlet distribution}
\usage{
feedbackDirichlet(d, quantiles = c(0.1, 0.9), sf = 2)
}
\arguments{
\item{d}{A vector of parameters of the Dirichlet distribution}

\item{quantiles}{The desired quantiles for feedback}

\item{sf}{The number of significant figures displayed}
}
\value{
Quantiles for each marginal distribution
}
\description{
Given a (elicited) Dirichlet distribution, calculate quantiles for each marginal
beta distribution corresponding to the elicited quantiles
}
\examples{
\dontrun{
feedbackDirichlet(d = c(20, 10, 5),
                  quantiles = c(0.1, 0.33, 0.66, 0.9))
}
}
\author{
Jeremy Oakley <j.oakley@sheffield.ac.uk>
}
