% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shark_api_functions.R
\name{get_shark_statistics}
\alias{get_shark_statistics}
\title{Summarize numeric SHARK parameters with ranges and outlier thresholds}
\usage{
get_shark_statistics(
  fromYear = NULL,
  toYear = NULL,
  datatype = NULL,
  group_col = NULL,
  min_obs = 3,
  max_non_numeric_frac = 0.05,
  cache_result = FALSE,
  prod = TRUE,
  utv = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{fromYear}{Start year for download (numeric).
Defaults to 5 years before the last complete year.}

\item{toYear}{End year for download (numeric).
Defaults to the last complete year.}

\item{datatype}{Optional, one or more datatypes to filter on
(e.g. \code{"Bacterioplankton"}). If \code{NULL}, all datatypes are included.}

\item{group_col}{Optional column name in the SHARK data to group by
(e.g. \code{"station_name"}). If provided, statistics will be computed separately
for each group. Default is \code{NULL}.}

\item{min_obs}{Minimum number of numeric observations required
for a parameter to be included (default: 3).}

\item{max_non_numeric_frac}{Maximum allowed fraction of non-numeric values
for a parameter to be kept (default: 0.05).}

\item{cache_result}{Logical, whether to save the result in a persistent cache
(\code{statistics.rds}) for use by other functions. Default is \code{FALSE}.}

\item{prod}{Logical, whether to download from the production
(\code{TRUE}, default) or test (\code{FALSE}) SHARK server. Ignored if \code{utv} is \code{TRUE}.}

\item{utv}{Logical. Select UTV server when \code{TRUE}.}

\item{verbose}{Logical, whether to show download progress messages. Default is \code{TRUE}.}
}
\value{
A tibble with one row per parameter (and optionally per group) and the following columns:
\describe{
\item{parameter}{Parameter name (character).}
\item{datatype}{SHARK datatype (character).}
\item{min, Q1, median, Q3, max}{Observed quantiles.}
\item{P01, P05, P95, P99}{1st, 5th, 95th and 99th percentiles.}
\item{IQR}{Interquartile range.}
\item{mean}{Arithmetic mean of numeric values.}
\item{sd}{Standard deviation of numeric values.}
\item{var}{Variance of numeric values.}
\item{cv}{Coefficient of variation (sd / mean).}
\item{mad}{Median absolute deviation.}
\item{mild_lower, mild_upper}{Lower/upper bounds for mild outliers (1.5 × IQR).}
\item{extreme_lower, extreme_upper}{Lower/upper bounds for extreme outliers (3 × IQR).}
\item{n}{Number of numeric observations used.}
\item{fromYear}{First year included in the SHARK data download (numeric).}
\item{toYear}{Last year included in the SHARK data download (numeric).}
\item{<group_col>}{Optional grouping column if provided.}
}
}
\description{
Downloads SHARK data for a given time period, filters to numeric parameters,
and calculates descriptive statistics and Tukey outlier thresholds.
}
\details{
By default, the function uses the \emph{previous five complete years}.
For example, if called in 2025 it will use data from 2020–2024.
}
\examples{
\donttest{
# Uses previous 5 years automatically, Chlorophyll data only
res <- get_shark_statistics(datatype = "Chlorophyll", verbose = FALSE)
print(res)

# Group by station name and save result in persistent cache
res_station <- get_shark_statistics(datatype = "Chlorophyll",
                                    group_col = "station_name",
                                    cache_result = TRUE,
                                    verbose = FALSE)
print(res_station)
}
}
