% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hab_api_functions.R
\name{get_hab_list}
\alias{get_hab_list}
\title{Download the IOC-UNESCO Taxonomic Reference List of Harmful Micro Algae}
\usage{
get_hab_list(
  aphia_id = TRUE,
  scientific_name = TRUE,
  authority = TRUE,
  fossil = TRUE,
  rank_name = TRUE,
  status_name = TRUE,
  qualitystatus_name = TRUE,
  modified = TRUE,
  lsid = TRUE,
  parent_id = TRUE,
  stored_path = TRUE,
  citation = TRUE,
  classification = TRUE,
  environment = TRUE,
  accepted_taxon = TRUE
)
}
\arguments{
\item{aphia_id}{Logical. Include the AphiaID field. Defaults to \code{TRUE}.}

\item{scientific_name}{Logical. Include the scientific name field. Defaults to \code{TRUE}.}

\item{authority}{Logical. Include the authority field. Defaults to \code{TRUE}.}

\item{fossil}{Logical. Include information about fossil status. Defaults to \code{TRUE}.}

\item{rank_name}{Logical. Include the taxonomic rank (e.g., species, variety, forma). Defaults to \code{TRUE}.}

\item{status_name}{Logical. Include the taxonomic status field. Defaults to \code{TRUE}.}

\item{qualitystatus_name}{Logical. Include the quality status field. Defaults to \code{TRUE}.}

\item{modified}{Logical. Include the date of last modification field. Defaults to \code{TRUE}.}

\item{lsid}{Logical. Include the Life Science Identifier (LSID) field. Defaults to \code{TRUE}.}

\item{parent_id}{Logical. Include the parent AphiaID field. Defaults to \code{TRUE}.}

\item{stored_path}{Logical. Include the stored path field. Defaults to \code{TRUE}.}

\item{citation}{Logical. Include citation information. Defaults to \code{TRUE}.}

\item{classification}{Logical. Include the full taxonomic classification (e.g., kingdom, phylum, class). Defaults to \code{TRUE}.}

\item{environment}{Logical. Include environmental data (e.g., marine, brackish, freshwater, terrestrial). Defaults to \code{TRUE}.}

\item{accepted_taxon}{Logical. Include information about the accepted taxon (e.g., scientific name and authority). Defaults to \code{TRUE}.}
}
\value{
A \code{tibble} containing the HABs taxonomic list, with columns based on the selected parameters.
}
\description{
This function retrieves the IOC-UNESCO Taxonomic Reference List of Harmful Micro Algae from the World Register of Marine Species (WoRMS).
The data is returned as a dataframe, with options to customize the fields included in the download.
}
\details{
This function submits a POST request to the WoRMS database to retrieve the IOC-UNESCO Taxonomic Reference List of Harmful Micro Algae.
The downloaded data can include various fields, which are controlled by the input parameters.
If a field is not required, set the corresponding parameter to \code{FALSE} to exclude it from the output.
}
\examples{
\donttest{
# Download the default HABs taxonomic list
habs_taxlist_df <- get_hab_list()
head(habs_taxlist_df)

# Include only specific fields in the output
habs_taxlist_df <- get_hab_list(aphia_id = TRUE, scientific_name = TRUE, authority = FALSE)
head(habs_taxlist_df)
}
}
\seealso{
\url{https://www.marinespecies.org/hab/} for IOC-UNESCO Taxonomic Reference List of Harmful Micro Algae
}
