% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shapboost_estimator.R
\docType{class}
\name{SHAPBoostEstimator-class}
\alias{SHAPBoostEstimator-class}
\alias{SHAPBoostEstimator}
\title{SHAPBoostEstimator Class}
\description{
This class implements the SHAPBoost algorithm for feature selection.
It is designed to be extended by specific implementations such as SHAPBoostRegressor and
SHAPBoostSurvival. Any new method should implement the abstract methods defined in this class.
}
\section{Fields}{

\describe{
\item{\code{evaluator}}{The model that is used to evaluate each additional feature.}

\item{\code{metric}}{A character string representing the evaluation metric.}

\item{\code{xgb_params}}{A list of parameters for the XGBoost model.}

\item{\code{number_of_folds}}{The number of folds for cross-validation.}

\item{\code{epsilon}}{A small value to determine convergence.}

\item{\code{max_number_of_features}}{The maximum number of features to select.}

\item{\code{siso_ranking_size}}{The number of features to consider in the SISO ranking.}

\item{\code{siso_order}}{The order of combinations to consider in SISO.}

\item{\code{reset}}{A logical indicating whether to reset the weights.}

\item{\code{num_resets}}{The number of resets allowed.}

\item{\code{fold_random_state}}{The random state for reproducibility in cross-validation.}

\item{\code{verbose}}{The verbosity level of the output.}

\item{\code{fixed_variables}}{A character vector of variable names to be always included.}

\item{\code{stratification}}{A logical indicating whether to use stratified sampling. Only applicable for c-index metric.}

\item{\code{collinearity_check}}{A logical indicating whether to check for collinearity.}

\item{\code{correlation_threshold}}{The threshold for correlation to consider features as collinear.}
}}


\examples{
if (requireNamespace("flare", quietly = TRUE)) {
  data("eyedata", package = "flare")
  shapboost <- SHAPBoostRegressor$new(
    max_number_of_features = 1,
    evaluator = "lr",
    metric = "mae",
    siso_ranking_size = 10,
    verbose = 0
  )
  X <- as.data.frame(x)
  y <- as.data.frame(y)
  subset <- shapboost$fit(X, y)
}

}
