% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Individuals-Methods.R
\name{loadIndividuals}
\alias{loadIndividuals}
\title{Wrapper function loadIndividuals}
\usage{
loadIndividuals(objectL, sp, data, mintime, maxtime)
}
\arguments{
\item{objectL}{a Landscape object}

\item{sp}{a SpatialPoint object (individuals coordinates)}

\item{data}{a data.frame containing individuals attributes. Rows numbers as individuals ID, columns names as dob (date of birth) | life_duration | toxic_threshold}

\item{mintime}{Start simulation time}

\item{maxtime}{End simulation time}
}
\value{
an \code{\link{Individuals-class}} object
}
\description{
Wrapper function to create an Individuals object using SpatialPoints and dataframe.

The SpatialPoints object and the data.frame have to contain the same number of coordinates and rows.
}
\examples{
 
\dontrun{
# simulate individuals coordinates (SpatialPoints object):
coordinates <- spsample(getSPReceptors(land),n=2)
df <- data.frame("dob"=c(1,8),"life_duration"=c(20,20),
           "toxic_threshold"=c(15,15),row.names = c(1,2))
ind <- loadIndividuals(objetL=land,sp=coordinates,data=df,mintime=1,maxtime=60)
}
}

