% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeData.R
\name{makeSimData}
\alias{makeSimData}
\title{Generate synthetic data according to a fixed effects model}
\usage{
makeSimData(
  H,
  n,
  L = 100,
  maf = 0.01,
  gamma0 = 1,
  gammaX = 1,
  gammaE = 1,
  gammaG,
  gammaGE,
  causal = 40,
  seed = 12345
)
}
\arguments{
\item{H}{Matrix of haplotype data (e.g. cosihap)}

\item{n}{Number of individuals}

\item{L}{Number of SNPs in the G matrix (Default is 100), should be a value between 1 and 604}

\item{maf}{Minor allele frequency (Default is 0.01)}

\item{gamma0}{gamma0 Fixed effect coefficient for intercept (Default is 1)}

\item{gammaX}{gammaX Fixed effect coefficient for confounding covariates (Default is 1)}

\item{gammaE}{gammaE Fixed effect coefficient for E effect (Default is 1)}

\item{gammaG}{gammaG Fixed effect coefficient for G main effect}

\item{gammaGE}{gammaGE Fixed effect coefficient for GxE interaction effect}

\item{causal}{Number of causal SNPs (default is 40)}

\item{seed}{Seed (Default is 12345)}
}
\value{
Synthetic dataset containing y, X, E, G, epsilon, and number of causal SNPs
}
\description{
This function generates synthetic from the fixed effects model described in the
experimental studies portion of the paper.
}
\examples{
dat <- makeSimData(H=cosihap, n=500, L=10, gammaG=1, gammaGE=0, causal=4, seed=1)

}
