\name{SDData}
\alias{SDData}
\alias{SDData.default}
\alias{print.SDData}
\alias{plot.SDData}
\alias{summary.SDData}
\alias{predict.SDData}
\title{Data container for SDisc analyses}
\description{\code{SDisc} dataset container constructor taking as input a description of the data and an analysis prefix.
\code{SDData} and its methods transform, print, summary and plot the data.}
\usage{
\method{SDData}{default}(x, prefix, dataOrig=NULL, TData=NULL, settings=NULL, initFun=list(SDDataCC), subset=NULL, ...)
\method{print}{SDData}(x, rseed=NULL, range=1:3, allNumVars = FALSE, latex=FALSE, ...)
\method{plot}{SDData}(x, q=NULL, est = 1, zlim = c(-2, 2), latex=FALSE, ...)
\method{summary}{SDData}(object, q=NULL, latex=FALSE,  digits = 3, ...)
\method{predict}{SDData}(object, newdata, prefix = "Newdata", subset = NULL, ...)
}
\arguments{
\item{x}{ a data matrix, a previously instantiated \code{SDData} container or an  \code{SDisc} object from which
the \code{SDData} will be extracted, }
\item{dataOrig}{ original data, NULL by default}
\item{TData}{ a set of operations \code{TData} to apply to the data}
\item{settings}{ a data matrix as generated by \code{SDDataSettings} or the path to a CSV file separated by ";"}
\item{initFun}{ a list of function taking a data matrix as input and returning a treated matrix as output. As default, returns all complete cases records}
\item{prefix}{ a prefix that will serve to identify the analysis in the dynamic report and to define the storage place}
\item{subset}{ a subset of record indeces for the data set (row names)}
\item{rseed}{ an integer to set the random number generator that will select randomly a set of rows and columns to
see before and after the data treatment, the data matrix}
\item{range}{ a sequence of integers to subset the randomly ordered column and row names vectors}
\item{allNumVars}{ whether all numeric variables should be printed, inclusive those not necessarily included in the
cluster modeling; these variables are retrieved from \code{dataOrig}}
\item{q}{ limit the summary to a subset of the data treatments (regular expression). When a character vector is
provided, the data treatments matching the regular expression are plotted side by side in an image.}
\item{est}{ TODO}
\item{zlim}{ limits for the heatmap}
\item{object}{ an data set container \code{SDData}}
\item{digits}{ how many digits should be reported in the \code{SDData} summary}
\item{newdata}{ a new dataset on which to apply the same transformation estimated on the first \code{SDData}}
\item{latex}{ whether the table  must be returned into a LaTeX code }
\item{\dots}{ additional parameters to be passed to the subfunctions}
}
\details{
\code{SDData} is the data container constructor for SDisc analyses. It proceeds copying the original data, creating
the working directories for figures and tables, and archive the dataset as an RData file. Default dataset
initialization function (\code{initFun}) filter out incomplete cases because clustering algorithm used in SDisc
(\code{Mclust}) does not handle missing values. To select a data \code{subset} from a previous \code{SDData}, a
selection index can also be passed. 

\code{predict} transforms a new data set based on the transformation estimates -like mean, standard deviation- from
another \code{SDData} container. 

\code{print} returns the data matrix that results from the initialization (e.g. complete cases) and  the data
treatments applied on the different variables, as defined in the data settings configuration file. To verify the
data treatments, an \code{rseed} can be provided to place in parallel a random extract of the data matrix before
and after the data treatments. The \code{range} parameter gives the number of rows and columns to extract randomly.

\code{plot} reports as PDF the boxplots and histograms for each variable of the  data set container. If
\code{latex} is set to TRUE, then LaTeX code for Sweave vignettes is returned.

\code{summary} returns a summary of the data treatments operated on the data set. For \code{mean}, \code{sd},
\code{scale}, etc, it returns the estimates. For \code{lm}, it returns the estimates of the coefficients along with
their standard error, $p$-value, the $R^2$ and adjusted $R^2$ of the transformation, and the number of records on
which the estimate was based on.  
}
\examples{
settings <- SDDataSettings(iris)
settings['Species',] <- c(NA,FALSE, NA, NA, NA,NA)
x <- SDData(iris, settings=settings, prefix='iris')
summary(x)
### DO NOT RUN
# plot(x)
}
\keyword{data}
\keyword{hplot}
\keyword{htest}
\keyword{manip}
\keyword{math}
\keyword{methods}
\keyword{models}
\keyword{print}
\keyword{regression}
\keyword{multivariate}

\seealso{ \code{\link{modelBasedEM}}, \code{\link{SDDataSettings}}, \code{\link{naPattern}},
\code{\link{SDDataSettings}}, \code{\link{SDisc}}, \code{\link{texTable}}, \code{\link{SDData}} }

\author{Fabrice Colas}
